/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TaskEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.TaskInstanceUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.event.TaskEventHandler;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.server.master.utils.DataQualityResultOperator;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCacheEventHandler
implements TaskEventHandler {
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    @Autowired
    private DataQualityResultOperator dataQualityResultOperator;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public void handleTaskEvent(TaskEvent taskEvent) {
        int taskInstanceId = taskEvent.getTaskInstanceId();
        int processInstanceId = taskEvent.getProcessInstanceId();
        WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(taskInstanceId);
        if (!taskInstanceOptional.isPresent()) {
            return;
        }
        TaskInstance taskInstance = taskInstanceOptional.get();
        this.dataQualityResultOperator.operateDqExecuteResult(taskEvent, taskInstance);
        TaskInstance cacheTaskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskEvent.getCacheTaskInstanceId()));
        cacheTaskInstance.setId(taskInstance.getId());
        cacheTaskInstance.setProcessInstanceId(processInstanceId);
        cacheTaskInstance.setProcessInstanceName(taskInstance.getProcessInstanceName());
        cacheTaskInstance.setProcessInstance(taskInstance.getProcessInstance());
        cacheTaskInstance.setProcessDefine(taskInstance.getProcessDefine());
        cacheTaskInstance.setStartTime(taskInstance.getSubmitTime());
        cacheTaskInstance.setSubmitTime(taskInstance.getSubmitTime());
        cacheTaskInstance.setEndTime(new Date());
        cacheTaskInstance.setFlag(Flag.YES);
        TaskInstanceUtils.copyTaskInstance((TaskInstance)cacheTaskInstance, (TaskInstance)taskInstance);
        this.processService.changeOutParam(taskInstance);
        this.taskInstanceDao.updateById((Object)taskInstance);
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskEvent.getProcessInstanceId()).taskInstanceId(taskEvent.getTaskInstanceId()).status(taskEvent.getState()).type(StateEventType.TASK_STATE_CHANGE).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    @Override
    public TaskEventType getHandleEventType() {
        return TaskEventType.CACHE;
    }
}

