/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TaskEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.TaskInstanceUtils;
import org.apache.dolphinscheduler.remote.command.task.TaskExecuteRunningMessageAck;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.TaskEventHandleError;
import org.apache.dolphinscheduler.server.master.event.TaskEventHandler;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskDelayEventHandler
implements TaskEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDelayEventHandler.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    @Autowired
    private MasterConfig masterConfig;

    @Override
    public void handleTaskEvent(TaskEvent taskEvent) throws TaskEventHandleError {
        int taskInstanceId = taskEvent.getTaskInstanceId();
        int processInstanceId = taskEvent.getProcessInstanceId();
        WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
        if (workflowExecuteRunnable == null) {
            this.sendAckToWorker(taskEvent);
            throw new TaskEventHandleError("Cannot find related workflow instance from cache");
        }
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(taskInstanceId);
        if (!taskInstanceOptional.isPresent()) {
            this.sendAckToWorker(taskEvent);
            return;
        }
        TaskInstance taskInstance = taskInstanceOptional.get();
        if (taskInstance.getState().isFinished()) {
            log.warn("The current task status is: {}, will not handle the running event, this event is delay, will discard this event: {}", (Object)taskInstance.getState(), (Object)taskEvent);
            this.sendAckToWorker(taskEvent);
            return;
        }
        TaskInstance oldTaskInstance = new TaskInstance();
        TaskInstanceUtils.copyTaskInstance((TaskInstance)taskInstance, (TaskInstance)oldTaskInstance);
        try {
            taskInstance.setState(taskEvent.getState());
            taskInstance.setStartTime(taskEvent.getStartTime());
            taskInstance.setHost(taskEvent.getWorkerAddress());
            taskInstance.setLogPath(taskEvent.getLogPath());
            taskInstance.setExecutePath(taskEvent.getExecutePath());
            taskInstance.setPid(taskEvent.getProcessId());
            taskInstance.setAppLink(taskEvent.getAppIds());
            if (!this.taskInstanceDao.updateById((Object)taskInstance)) {
                throw new TaskEventHandleError("Handle task delay event error, update taskInstance to db failed");
            }
            this.sendAckToWorker(taskEvent);
        }
        catch (Exception ex) {
            TaskInstanceUtils.copyTaskInstance((TaskInstance)oldTaskInstance, (TaskInstance)taskInstance);
            if (ex instanceof TaskEventHandleError) {
                throw ex;
            }
            throw new TaskEventHandleError("Handle task dispatch event error, update taskInstance to db failed", ex);
        }
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskEvent.getProcessInstanceId()).taskInstanceId(taskEvent.getTaskInstanceId()).status(taskEvent.getState()).type(StateEventType.TASK_STATE_CHANGE).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private void sendAckToWorker(TaskEvent taskEvent) {
        TaskExecuteRunningMessageAck taskExecuteRunningMessageAck = new TaskExecuteRunningMessageAck(true, taskEvent.getTaskInstanceId(), this.masterConfig.getMasterAddress(), taskEvent.getWorkerAddress(), System.currentTimeMillis());
        taskEvent.getChannel().writeAndFlush((Object)taskExecuteRunningMessageAck.convert2Command());
    }

    @Override
    public TaskEventType getHandleEventType() {
        return TaskEventType.DELAY;
    }
}

