/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class TaskTimeoutStateEventHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskTimeoutStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleError, StateEventHandleException {
        TaskStateEvent taskStateEvent = (TaskStateEvent)stateEvent;
        TaskMetrics.incTaskInstanceByState("timeout");
        workflowExecuteRunnable.checkTaskInstanceByStateEvent(taskStateEvent);
        TaskInstance taskInstance = workflowExecuteRunnable.getTaskInstance(taskStateEvent.getTaskInstanceId()).orElseThrow(() -> new StateEventHandleError(String.format("Cannot find the task instance from workflow execute runnable, taskInstanceId: %s", taskStateEvent.getTaskInstanceId())));
        log.info("Handle task instance state timeout event, taskInstanceId: {}", (Object)taskStateEvent.getTaskInstanceId());
        if (TimeoutFlag.CLOSE == taskInstance.getTaskDefine().getTimeoutFlag()) {
            return true;
        }
        TaskTimeoutStrategy taskTimeoutStrategy = taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        Map<Long, DefaultTaskExecuteRunnable> taskExecuteRunnableMap = workflowExecuteRunnable.getTaskExecuteRunnableMap();
        if (TaskTimeoutStrategy.FAILED == taskTimeoutStrategy || TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
            if (taskExecuteRunnableMap.containsKey(taskInstance.getTaskCode())) {
                taskExecuteRunnableMap.get(taskInstance.getTaskCode()).timeout();
                workflowExecuteRunnable.taskFinished(taskInstance);
            } else {
                log.warn("cannot find the task processor for task {}, so skip task processor action.", (Object)taskInstance.getTaskCode());
            }
        }
        if (TaskTimeoutStrategy.WARN == taskTimeoutStrategy || TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
            workflowExecuteRunnable.processTimeout();
            workflowExecuteRunnable.taskTimeout(taskInstance);
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.TASK_TIMEOUT;
    }
}

