/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class TaskWaitTaskGroupStateHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskWaitTaskGroupStateHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) {
        log.info("Handle task instance wait task group event, taskInstanceId: {}", (Object)stateEvent.getTaskInstanceId());
        if (workflowExecuteRunnable.checkForceStartAndWakeUp(stateEvent)) {
            log.info("Success wake up task instance, taskInstanceId: {}", (Object)stateEvent.getTaskInstanceId());
        } else {
            log.info("Failed to wake up task instance, taskInstanceId: {}", (Object)stateEvent.getTaskInstanceId());
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.WAKE_UP_TASK_GROUP;
    }
}

