/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.parameters.BlockingParameters;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowBlockStateEventHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowBlockStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleError {
        log.info("Handle workflow instance state block event");
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(stateEvent.getTaskInstanceId());
        if (!taskInstanceOptional.isPresent()) {
            throw new StateEventHandleError("Cannot find taskInstance from taskMap by taskInstanceId: " + stateEvent.getTaskInstanceId());
        }
        TaskInstance task = taskInstanceOptional.get();
        BlockingParameters parameters = (BlockingParameters)JSONUtils.parseObject((String)task.getTaskParams(), BlockingParameters.class);
        if (parameters != null && parameters.isAlertWhenBlocking()) {
            workflowExecuteRunnable.processBlock();
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_BLOCKED;
    }
}

