/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.graph;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.server.master.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.service.model.TaskNode;

public class WorkflowGraph
implements IWorkflowGraph {
    private final Map<Long, TaskNode> taskNodeMap;
    private final DAG<Long, TaskNode, TaskNodeRelation> dag;
    private final Set<Long> forbiddenTaskCodes;

    public WorkflowGraph(List<TaskNode> taskNodes, DAG<Long, TaskNode, TaskNodeRelation> dag) {
        Preconditions.checkNotNull(taskNodes, (Object)"taskNodes can not be null");
        Preconditions.checkNotNull(dag, (Object)"dag can not be null");
        this.taskNodeMap = taskNodes.stream().collect(Collectors.toMap(TaskNode::getCode, Function.identity()));
        this.dag = dag;
        this.forbiddenTaskCodes = taskNodes.stream().filter(TaskNode::isForbidden).map(TaskNode::getCode).collect(Collectors.toSet());
    }

    @Override
    public TaskNode getTaskNodeByCode(Long taskCode) {
        TaskNode taskNode = this.taskNodeMap.get(taskCode);
        if (taskNode == null) {
            throw new IllegalArgumentException("task node not found, taskCode: " + taskCode);
        }
        return taskNode;
    }

    @Override
    public DAG<Long, TaskNode, TaskNodeRelation> getDag() {
        return this.dag;
    }

    @Override
    public boolean isForbiddenTask(Long taskCode) {
        return this.forbiddenTaskCodes.contains(taskCode);
    }
}

