/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.metrics;

import com.google.common.collect.ImmutableSet;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;

public final class TaskMetrics {
    private static final Map<String, Counter> taskInstanceCounters = new HashMap<String, Counter>();
    private static final Set<String> taskInstanceStates = ImmutableSet.of((Object)"submit", (Object)"timeout", (Object)"finish", (Object)"failover", (Object)"retry", (Object)"dispatch", (Object[])new String[]{"success", "kill", "fail", "stop"});
    private static final Counter taskDispatchCounter;
    private static final Counter taskDispatchFailCounter;
    private static final Counter taskDispatchErrorCounter;

    public static synchronized void registerTaskPrepared(Supplier<Number> consumer) {
        Gauge.builder((String)"ds.task.prepared", consumer).description("Task prepared count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incTaskDispatchFailed(int failedCount) {
        taskDispatchFailCounter.increment((double)failedCount);
    }

    public static void incTaskDispatchError() {
        taskDispatchErrorCounter.increment();
    }

    public static void incTaskDispatch() {
        taskDispatchCounter.increment();
    }

    public static void incTaskInstanceByState(String state) {
        if (taskInstanceCounters.get(state) == null) {
            return;
        }
        taskInstanceCounters.get(state).increment();
    }

    @Generated
    private TaskMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (String state : taskInstanceStates) {
            taskInstanceCounters.put(state, Counter.builder((String)"ds.task.instance.count").tags(new String[]{"state", state}).description(String.format("Process instance %s total count", state)).register((MeterRegistry)Metrics.globalRegistry));
        }
        taskDispatchCounter = Counter.builder((String)"ds.task.dispatch.count").description("Task dispatch count").register((MeterRegistry)Metrics.globalRegistry);
        taskDispatchFailCounter = Counter.builder((String)"ds.task.dispatch.failure.count").description("Task dispatch failures count, retried ones included").register((MeterRegistry)Metrics.globalRegistry);
        taskDispatchErrorCounter = Counter.builder((String)"ds.task.dispatch.error.count").description("Number of errors during task dispatch").register((MeterRegistry)Metrics.globalRegistry);
    }
}

