/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.CacheType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.cache.CacheExpireRequest;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class CacheProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheProcessor.class);
    @Autowired
    private CacheManager cacheManager;

    public void process(Channel channel, Message message) {
        CacheExpireRequest cacheExpireRequest = (CacheExpireRequest)JSONUtils.parseObject((byte[])message.getBody(), CacheExpireRequest.class);
        log.info("received command : {}", (Object)cacheExpireRequest);
        this.cacheExpire(cacheExpireRequest);
    }

    public MessageType getCommandType() {
        return MessageType.CACHE_EXPIRE;
    }

    private void cacheExpire(CacheExpireRequest cacheExpireRequest) {
        if (cacheExpireRequest.getCacheKey().isEmpty()) {
            return;
        }
        CacheType cacheType = cacheExpireRequest.getCacheType();
        Cache cache = this.cacheManager.getCache(cacheType.getCacheName());
        if (cache != null) {
            cache.evict((Object)cacheExpireRequest.getCacheKey());
            log.info("cache evict, type:{}, key:{}", (Object)cacheType.getCacheName(), (Object)cacheExpireRequest.getCacheKey());
        }
    }
}

