/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskKillRequest;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.MasterDelayTaskExecuteRunnableDelayQueue;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskKillProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterTaskKillProcessor.class);
    @Autowired
    private MasterDelayTaskExecuteRunnableDelayQueue masterDelayTaskExecuteRunnableDelayQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Message message) {
        TaskKillRequest taskKillRequest = (TaskKillRequest)JSONUtils.parseObject((byte[])message.getBody(), TaskKillRequest.class);
        log.info("Master receive task kill request: {}", (Object)taskKillRequest);
        int taskInstanceId = taskKillRequest.getTaskInstanceId();
        try (LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);){
            TaskExecutionContext taskExecutionContext = MasterTaskExecutionContextHolder.getTaskExecutionContext(taskInstanceId);
            if (taskExecutionContext == null) {
                log.error("Cannot find the TaskExecutionContext, this task may already been killed");
                return;
            }
            MasterTaskExecuteRunnable masterTaskExecuteRunnable = MasterTaskExecuteRunnableHolder.getMasterTaskExecuteRunnable(taskInstanceId);
            if (masterTaskExecuteRunnable == null) {
                log.error("Cannot find the MasterTaskExecuteRunnable, this task may already been killed");
                return;
            }
            try {
                masterTaskExecuteRunnable.cancelTask();
                this.masterDelayTaskExecuteRunnableDelayQueue.removeMasterDelayTaskExecuteRunnable(masterTaskExecuteRunnable);
            }
            catch (MasterTaskExecuteException e) {
                log.error("Cancel MasterTaskExecuteRunnable failed ", (Throwable)e);
            }
            finally {
                MasterTaskExecutionContextHolder.removeTaskExecutionContext(taskInstanceId);
                MasterTaskExecuteRunnableHolder.removeMasterTaskExecuteRunnable(taskInstanceId);
            }
        }
    }

    public MessageType getCommandType() {
        return MessageType.TASK_KILL_REQUEST;
    }
}

