/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskPauseRequest;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskPauseProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterTaskPauseProcessor.class);

    public void process(Channel channel, Message message) {
        TaskPauseRequest taskPauseRequest = (TaskPauseRequest)JSONUtils.parseObject((byte[])message.getBody(), TaskPauseRequest.class);
        MasterTaskExecuteRunnable masterTaskExecuteRunnable = MasterTaskExecuteRunnableHolder.getMasterTaskExecuteRunnable(taskPauseRequest.getTaskInstanceId());
        if (masterTaskExecuteRunnable == null) {
            log.info("Cannot find the MasterTaskExecuteRunnable");
            return;
        }
        TaskExecutionContext taskExecutionContext = masterTaskExecuteRunnable.getTaskExecutionContext();
        try {
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskExecutionContext.getProcessInstanceId(), (Integer)taskExecutionContext.getTaskInstanceId());
            masterTaskExecuteRunnable.pauseTask();
        }
        catch (MasterTaskExecuteException e) {
            log.error("Pause MasterTaskExecuteRunnable failed", (Throwable)e);
        }
    }

    public MessageType getCommandType() {
        return MessageType.PAUSE_TASK_INSTANCE;
    }
}

