/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowStateEventChangeRequest;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.StateEventResponseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StateEventProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateEventProcessor.class);
    @Autowired
    private StateEventResponseService stateEventResponseService;

    public void process(Channel channel, Message message) {
        WorkflowStateEventChangeRequest workflowStateEventChangeRequest = (WorkflowStateEventChangeRequest)JSONUtils.parseObject((byte[])message.getBody(), WorkflowStateEventChangeRequest.class);
        StateEvent stateEvent = workflowStateEventChangeRequest.getDestTaskInstanceId() == 0 ? this.createWorkflowStateEvent(workflowStateEventChangeRequest) : this.createTaskStateEvent(workflowStateEventChangeRequest);
        try (LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)stateEvent.getProcessInstanceId(), (Integer)stateEvent.getTaskInstanceId());){
            log.info("Received state change command, event: {}", (Object)stateEvent);
            this.stateEventResponseService.addStateChangeEvent(stateEvent);
        }
    }

    public MessageType getCommandType() {
        return MessageType.STATE_EVENT_REQUEST;
    }

    private TaskStateEvent createTaskStateEvent(WorkflowStateEventChangeRequest workflowStateEventChangeRequest) {
        return TaskStateEvent.builder().processInstanceId(workflowStateEventChangeRequest.getDestProcessInstanceId()).taskInstanceId(workflowStateEventChangeRequest.getDestTaskInstanceId()).type(StateEventType.TASK_STATE_CHANGE).key(workflowStateEventChangeRequest.getKey()).build();
    }

    private WorkflowStateEvent createWorkflowStateEvent(WorkflowStateEventChangeRequest workflowStateEventChangeRequest) {
        WorkflowExecutionStatus workflowExecutionStatus = workflowStateEventChangeRequest.getSourceStatus();
        if (workflowStateEventChangeRequest.getSourceProcessInstanceId() != workflowStateEventChangeRequest.getDestProcessInstanceId()) {
            workflowExecutionStatus = WorkflowExecutionStatus.RUNNING_EXECUTION;
        }
        return WorkflowStateEvent.builder().processInstanceId(workflowStateEventChangeRequest.getDestProcessInstanceId()).type(StateEventType.PROCESS_STATE_CHANGE).status(workflowExecutionStatus).key(workflowStateEventChangeRequest.getKey()).build();
    }
}

