/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskExecuteResultMessage;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteResultProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecuteResultProcessor.class);
    @Autowired
    private TaskEventService taskEventService;

    public void process(Channel channel, Message message) {
        TaskExecuteResultMessage taskExecuteResultMessage = (TaskExecuteResultMessage)JSONUtils.parseObject((byte[])message.getBody(), TaskExecuteResultMessage.class);
        TaskEvent taskResultEvent = TaskEvent.newResultEvent(taskExecuteResultMessage, channel, taskExecuteResultMessage.getMessageSenderAddress());
        try (LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskResultEvent.getProcessInstanceId(), (Integer)taskResultEvent.getTaskInstanceId());){
            log.info("Received task execute result, event: {}", (Object)taskResultEvent);
            this.taskEventService.addEvent(taskResultEvent);
        }
    }

    public MessageType getCommandType() {
        return MessageType.TASK_EXECUTE_RESULT_MESSAGE;
    }
}

