/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskExecuteStartMessage;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteStartProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecuteStartProcessor.class);
    @Autowired
    private StreamTaskExecuteThreadPool streamTaskExecuteThreadPool;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;

    public void process(Channel channel, Message message) {
        TaskExecuteStartMessage taskExecuteStartMessage = (TaskExecuteStartMessage)JSONUtils.parseObject((byte[])message.getBody(), TaskExecuteStartMessage.class);
        log.info("taskExecuteStartCommand: {}", (Object)taskExecuteStartMessage);
        TaskDefinition taskDefinition = this.taskDefinitionDao.findTaskDefinition(taskExecuteStartMessage.getTaskDefinitionCode(), taskExecuteStartMessage.getTaskDefinitionVersion());
        if (taskDefinition == null) {
            log.error("Task definition can not be found, taskDefinitionCode:{}, taskDefinitionVersion:{}", (Object)taskExecuteStartMessage.getTaskDefinitionCode(), (Object)taskExecuteStartMessage.getTaskDefinitionVersion());
            return;
        }
        this.streamTaskExecuteThreadPool.execute(new StreamTaskExecuteRunnable(taskDefinition, taskExecuteStartMessage));
        Message response = new Message(message.getOpaque());
        response.setType(MessageType.TASK_EXECUTE_START);
        response.setBody(new byte[0]);
        channel.writeAndFlush((Object)response);
    }

    public MessageType getCommandType() {
        return MessageType.TASK_EXECUTE_START;
    }
}

