/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskForceStartRequest;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.StateEventResponseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskForceStartProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskForceStartProcessor.class);
    @Autowired
    private StateEventResponseService stateEventResponseService;

    public void process(Channel channel, Message message) {
        TaskForceStartRequest taskEventChangeCommand = (TaskForceStartRequest)JSONUtils.parseObject((byte[])message.getBody(), TaskForceStartRequest.class);
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(taskEventChangeCommand.getProcessInstanceId()).taskInstanceId(taskEventChangeCommand.getTaskInstanceId()).key(taskEventChangeCommand.getKey()).type(StateEventType.WAKE_UP_TASK_GROUP).build();
        try (LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)stateEvent.getProcessInstanceId(), (Integer)stateEvent.getTaskInstanceId());){
            log.info("Received task event change command, event: {}", (Object)stateEvent);
            this.stateEventResponseService.addEvent2WorkflowExecute(stateEvent);
        }
    }

    public MessageType getCommandType() {
        return MessageType.TASK_FORCE_STATE_EVENT_REQUEST;
    }
}

