/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowExecutingDataRequest;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowExecutingDataResponse;
import org.apache.dolphinscheduler.remote.dto.WorkflowExecuteDto;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.server.master.service.ExecutingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowExecutingDataRequestProcessor
implements MasterRpcProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecutingDataRequestProcessor.class);
    @Autowired
    private ExecutingService executingService;

    public void process(Channel channel, Message message) {
        WorkflowExecutingDataRequest requestCommand = (WorkflowExecutingDataRequest)JSONUtils.parseObject((byte[])message.getBody(), WorkflowExecutingDataRequest.class);
        log.info("received command, processInstanceId:{}", (Object)requestCommand.getProcessInstanceId());
        Optional<WorkflowExecuteDto> workflowExecuteDtoOptional = this.executingService.queryWorkflowExecutingData(requestCommand.getProcessInstanceId());
        WorkflowExecutingDataResponse responseCommand = new WorkflowExecutingDataResponse();
        workflowExecuteDtoOptional.ifPresent(arg_0 -> ((WorkflowExecutingDataResponse)responseCommand).setWorkflowExecuteDto(arg_0));
        channel.writeAndFlush((Object)responseCommand.convert2Command(message.getOpaque()));
    }

    public MessageType getCommandType() {
        return MessageType.WORKFLOW_EXECUTING_DATA_REQUEST;
    }
}

