/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConnectionStateListener
implements ConnectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterConnectionStateListener.class);
    private final MasterConfig masterConfig;
    private final RegistryClient registryClient;
    private final MasterConnectStrategy masterConnectStrategy;

    public MasterConnectionStateListener(@NonNull MasterConfig masterConfig, @NonNull RegistryClient registryClient, @NonNull MasterConnectStrategy masterConnectStrategy) {
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (masterConnectStrategy == null) {
            throw new NullPointerException("masterConnectStrategy is marked non-null but is null");
        }
        this.masterConfig = masterConfig;
        this.registryClient = registryClient;
        this.masterConnectStrategy = masterConnectStrategy;
    }

    public void onUpdate(ConnectionState state) {
        log.info("Master received a {} event from registry, the current server state is {}", (Object)state, (Object)ServerLifeCycleManager.getServerStatus());
        switch (state) {
            case CONNECTED: {
                break;
            }
            case SUSPENDED: {
                break;
            }
            case RECONNECTED: {
                this.masterConnectStrategy.reconnect();
                break;
            }
            case DISCONNECTED: {
                this.masterConnectStrategy.disconnect();
                break;
            }
        }
    }
}

