/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.StrategyType;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="master.registry-disconnect-strategy", name={"strategy"}, havingValue="stop", matchIfMissing=true)
public class MasterStopStrategy
implements MasterConnectStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterStopStrategy.class);
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterConfig masterConfig;

    public void disconnect() {
        this.registryClient.getStoppable().stop("Master disconnected from registry, will stop myself due to the stop strategy");
    }

    public void reconnect() {
        log.warn("The current connect strategy is stop, so the master will not reconnect to registry");
    }

    public StrategyType getStrategyType() {
        return StrategyType.STOP;
    }
}

