/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.time.Duration;
import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleException;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.StrategyType;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventQueue;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectStrategy;
import org.apache.dolphinscheduler.server.master.rpc.MasterRPCServer;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="master.registry-disconnect-strategy", name={"strategy"}, havingValue="waiting")
public class MasterWaitingStrategy
implements MasterConnectStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterWaitingStrategy.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterRPCServer masterRPCServer;
    @Autowired
    private WorkflowEventQueue workflowEventQueue;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;

    public void disconnect() {
        try {
            ServerLifeCycleManager.toWaiting();
            this.clearMasterResource();
            Duration maxWaitingTime = this.masterConfig.getRegistryDisconnectStrategy().getMaxWaitingTime();
            try {
                log.info("Master disconnect from registry will try to reconnect in {} s", (Object)maxWaitingTime.getSeconds());
                this.registryClient.connectUntilTimeout(maxWaitingTime);
            }
            catch (RegistryException ex) {
                throw new ServerLifeCycleException(String.format("Waiting to reconnect to registry in %s failed", maxWaitingTime), (Throwable)ex);
            }
        }
        catch (ServerLifeCycleException e) {
            String errorMessage = String.format("Disconnect from registry and change the current status to waiting error, the current server state is %s, will stop the current server", ServerLifeCycleManager.getServerStatus());
            log.error(errorMessage, (Throwable)e);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (RegistryException ex) {
            String errorMessage = "Disconnect from registry and waiting to reconnect failed, will stop the server";
            log.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (Exception ex) {
            String errorMessage = "Disconnect from registry and get an unknown exception, will stop the server";
            log.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
    }

    public void reconnect() {
        if (ServerLifeCycleManager.isRunning()) {
            log.info("no need to reconnect, as the current server status is running");
        } else {
            try {
                ServerLifeCycleManager.recoverFromWaiting();
                this.reStartMasterResource();
                log.info("Recover from waiting success, the current server status is {}", (Object)ServerLifeCycleManager.getServerStatus());
            }
            catch (Exception e) {
                String errorMessage = String.format("Recover from waiting failed, the current server status is %s, will stop the server", ServerLifeCycleManager.getServerStatus());
                log.error(errorMessage, (Throwable)e);
                this.registryClient.getStoppable().stop(errorMessage);
            }
        }
    }

    public StrategyType getStrategyType() {
        return StrategyType.WAITING;
    }

    private void clearMasterResource() {
        this.masterRPCServer.close();
        log.warn("Master closed RPC server due to lost registry connection");
        this.workflowEventQueue.clearWorkflowEventQueue();
        log.warn("Master clear workflow event queue due to lost registry connection");
        this.processInstanceExecCacheManager.clearCache();
        log.warn("Master clear process instance cache due to lost registry connection");
        this.stateWheelExecuteThread.clearAllTasks();
        log.warn("Master clear all state wheel task due to lost registry connection");
    }

    private void reStartMasterResource() {
        this.masterRPCServer.start();
        log.warn("Master restarted RPC server due to reconnect to registry");
    }
}

