/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.MasterRpcProcessor;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterRPCServer
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterRPCServer.class);
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private List<MasterRpcProcessor> masterRpcProcessors;

    public void start() {
        log.info("Starting Master RPC Server...");
        NettyServerConfig serverConfig = this.masterConfig.getMasterRpcServerConfig();
        serverConfig.setListenPort(this.masterConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        for (MasterRpcProcessor masterRpcProcessor : this.masterRpcProcessors) {
            this.nettyRemotingServer.registerProcessor((NettyRequestProcessor)masterRpcProcessor);
            log.info("Success register netty processor: {}", (Object)masterRpcProcessor.getClass().getName());
        }
        this.nettyRemotingServer.start();
        log.info("Started Master RPC Server...");
    }

    @Override
    public void close() {
        log.info("Closing Master RPC Server...");
        this.nettyRemotingServer.close();
        log.info("Closed Master RPC Server...");
    }
}

