/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterRpcClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterRpcClient.class);
    @Autowired
    private MasterConfig masterConfig;
    private static final long DEFAULT_TIME_OUT_MILLS = 10000L;
    private NettyRemotingClient client;

    public void start() {
        this.client = new NettyRemotingClient(this.masterConfig.getMasterRpcClientConfig());
        log.info("Success initialized MasterRPCClient...");
    }

    public Message sendSyncCommand(@NonNull Host host, @NonNull Message rpcMessage) throws RemotingException, InterruptedException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (rpcMessage == null) {
            throw new NullPointerException("rpcMessage is marked non-null but is null");
        }
        return this.client.sendSync(host, rpcMessage, 10000L);
    }

    public void send(@NonNull Host host, @NonNull Message message) throws RemotingException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.client.send(host, message);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

