/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.server.master.runner.MasterDelayTaskExecuteRunnableDelayQueue;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterDelayTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterDelayTaskExecuteRunnableDelayQueueLooper
extends BaseDaemonThread
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterDelayTaskExecuteRunnableDelayQueueLooper.class);
    @Autowired
    private MasterDelayTaskExecuteRunnableDelayQueue masterDelayTaskExecuteRunnableDelayQueue;
    @Autowired
    private MasterTaskExecuteRunnableThreadPool masterTaskExecuteRunnableThreadPool;
    private final AtomicBoolean RUNNING_FLAG = new AtomicBoolean(false);

    public MasterDelayTaskExecuteRunnableDelayQueueLooper() {
        super("MasterDelayTaskExecuteRunnableDelayQueueLooper");
    }

    public synchronized void start() {
        if (!this.RUNNING_FLAG.compareAndSet(false, true)) {
            log.error("The MasterDelayTaskExecuteRunnableDelayQueueLooper already started, will not start again");
            return;
        }
        log.info("MasterDelayTaskExecuteRunnableDelayQueueLooper starting...");
        super.start();
        this.masterTaskExecuteRunnableThreadPool.start();
        log.info("MasterDelayTaskExecuteRunnableDelayQueueLooper started...");
    }

    public void run() {
        while (this.RUNNING_FLAG.get()) {
            try {
                MasterDelayTaskExecuteRunnable masterDelayTaskExecuteRunnable = this.masterDelayTaskExecuteRunnableDelayQueue.takeMasterDelayTaskExecuteRunnable();
                this.masterTaskExecuteRunnableThreadPool.submitMasterTaskExecuteRunnable(masterDelayTaskExecuteRunnable);
                MasterTaskExecuteRunnableHolder.putMasterTaskExecuteRunnable(masterDelayTaskExecuteRunnable);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                log.warn("MasterDelayTaskExecuteRunnableDelayQueueLooper has been interrupted, will stop loop");
                break;
            }
        }
        log.info("MasterDelayTaskExecuteRunnableDelayQueueLooper stop loop...");
    }

    @Override
    public void close() throws Exception {
        if (this.RUNNING_FLAG.compareAndSet(true, false)) {
            log.info("MasterDelayTaskExecuteRunnableDelayQueueLooper stopping...");
            log.info("MasterDelayTaskExecuteRunnableDelayQueueLooper stopped...");
        }
    }
}

