/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class StreamTaskExecuteThreadPool
extends ThreadPoolTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamTaskExecuteThreadPool.class);
    @Autowired
    private MasterConfig masterConfig;

    @PostConstruct
    private void init() {
        this.setDaemon(true);
        this.setThreadNamePrefix("StreamTaskExecuteThread-");
        this.setMaxPoolSize(this.masterConfig.getExecThreads());
        this.setCorePoolSize(this.masterConfig.getExecThreads());
    }

    public void executeEvent(StreamTaskExecuteRunnable streamTaskExecuteRunnable) {
        if (!streamTaskExecuteRunnable.isStart() || streamTaskExecuteRunnable.eventSize() == 0) {
            return;
        }
        final int taskInstanceId = streamTaskExecuteRunnable.getTaskInstance().getId();
        ListenableFuture future = this.submitListenable(streamTaskExecuteRunnable::handleEvents);
        future.addCallback(new ListenableFutureCallback(){

            public void onFailure(Throwable ex) {
                LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
                log.error("Stream task instance events handle failed", ex);
                LogUtils.removeTaskInstanceIdMDC();
            }

            public void onSuccess(Object result) {
                LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
                log.info("Stream task instance is finished.");
                LogUtils.removeTaskInstanceIdMDC();
            }
        });
    }
}

