/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.TaskCacheUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.SwitchResultVo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.task.TaskWakeupRequest;
import org.apache.dolphinscheduler.remote.command.task.WorkflowHostChangeRequest;
import org.apache.dolphinscheduler.remote.command.task.WorkflowHostChangeResponse;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleFailure;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.StateEventHandlerManager;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.exception.TaskExecuteRunnableCreateException;
import org.apache.dolphinscheduler.server.master.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowStartStatus;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnableFactory;
import org.apache.dolphinscheduler.server.master.runner.execute.TaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.utils.TaskUtils;
import org.apache.dolphinscheduler.server.master.utils.WorkflowInstanceUtils;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.apache.dolphinscheduler.service.cron.CronUtils;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.queue.PeerTaskInstancePriorityQueue;
import org.apache.dolphinscheduler.service.utils.DagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class WorkflowExecuteRunnable
implements IWorkflowExecuteRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecuteRunnable.class);
    private final ProcessService processService;
    private final CommandService commandService;
    private final ProcessInstanceDao processInstanceDao;
    private final TaskInstanceDao taskInstanceDao;
    private final ProcessAlertManager processAlertManager;
    private final MasterRpcClient masterRpcClient;
    private final IWorkflowExecuteContext workflowExecuteContext;
    private WorkflowRunnableStatus workflowRunnableStatus = WorkflowRunnableStatus.CREATED;
    private boolean taskFailedSubmit = false;
    private final Map<Integer, TaskInstance> taskInstanceMap = new ConcurrentHashMap<Integer, TaskInstance>();
    private final Map<Long, TaskInstance> taskCodeInstanceMap = new ConcurrentHashMap<Long, TaskInstance>();
    private final Map<Long, DefaultTaskExecuteRunnable> taskExecuteRunnableMap = new ConcurrentHashMap<Long, DefaultTaskExecuteRunnable>();
    private final Map<Long, Integer> validTaskMap = new ConcurrentHashMap<Long, Integer>();
    private final Map<Long, Integer> errorTaskMap = new ConcurrentHashMap<Long, Integer>();
    private final Set<Long> completeTaskSet = Sets.newConcurrentHashSet();
    private final Set<Long> dependFailedTaskSet = Sets.newConcurrentHashSet();
    private final Map<Long, TaskNode> skipTaskNodeMap = new ConcurrentHashMap<Long, TaskNode>();
    private List<Date> complementListDate = Lists.newLinkedList();
    private final ConcurrentLinkedQueue<StateEvent> stateEvents = new ConcurrentLinkedQueue();
    private final PeerTaskInstancePriorityQueue readyToSubmitTaskQueue = new PeerTaskInstancePriorityQueue();
    private final Map<Long, TaskInstance> waitToRetryTaskInstanceMap = new ConcurrentHashMap<Long, TaskInstance>();
    private final StateWheelExecuteThread stateWheelExecuteThread;
    private final CuringParamsService curingParamsService;
    private final DefaultTaskExecuteRunnableFactory defaultTaskExecuteRunnableFactory;
    private final MasterConfig masterConfig;

    public WorkflowExecuteRunnable(@NonNull IWorkflowExecuteContext workflowExecuteContext, @NonNull CommandService commandService, @NonNull ProcessService processService, @NonNull ProcessInstanceDao processInstanceDao, @NonNull MasterRpcClient masterRpcClient, @NonNull ProcessAlertManager processAlertManager, @NonNull MasterConfig masterConfig, @NonNull StateWheelExecuteThread stateWheelExecuteThread, @NonNull CuringParamsService curingParamsService, @NonNull TaskInstanceDao taskInstanceDao, @NonNull DefaultTaskExecuteRunnableFactory defaultTaskExecuteRunnableFactory) {
        if (workflowExecuteContext == null) {
            throw new NullPointerException("workflowExecuteContext is marked non-null but is null");
        }
        if (commandService == null) {
            throw new NullPointerException("commandService is marked non-null but is null");
        }
        if (processService == null) {
            throw new NullPointerException("processService is marked non-null but is null");
        }
        if (processInstanceDao == null) {
            throw new NullPointerException("processInstanceDao is marked non-null but is null");
        }
        if (masterRpcClient == null) {
            throw new NullPointerException("masterRpcClient is marked non-null but is null");
        }
        if (processAlertManager == null) {
            throw new NullPointerException("processAlertManager is marked non-null but is null");
        }
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (stateWheelExecuteThread == null) {
            throw new NullPointerException("stateWheelExecuteThread is marked non-null but is null");
        }
        if (curingParamsService == null) {
            throw new NullPointerException("curingParamsService is marked non-null but is null");
        }
        if (taskInstanceDao == null) {
            throw new NullPointerException("taskInstanceDao is marked non-null but is null");
        }
        if (defaultTaskExecuteRunnableFactory == null) {
            throw new NullPointerException("defaultTaskExecuteRunnableFactory is marked non-null but is null");
        }
        this.processService = processService;
        this.commandService = commandService;
        this.processInstanceDao = processInstanceDao;
        this.workflowExecuteContext = workflowExecuteContext;
        this.masterRpcClient = masterRpcClient;
        this.masterConfig = masterConfig;
        this.processAlertManager = processAlertManager;
        this.stateWheelExecuteThread = stateWheelExecuteThread;
        this.curingParamsService = curingParamsService;
        this.taskInstanceDao = taskInstanceDao;
        this.defaultTaskExecuteRunnableFactory = defaultTaskExecuteRunnableFactory;
        TaskMetrics.registerTaskPrepared(() -> ((PeerTaskInstancePriorityQueue)this.readyToSubmitTaskQueue).size());
    }

    public boolean isStart() {
        return WorkflowRunnableStatus.STARTED == this.workflowRunnableStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents() {
        if (!this.isStart()) {
            log.info("The workflow instance is not started, will not handle its state event, current state event size: {}", this.stateEvents);
            return;
        }
        int loopTimes = this.stateEvents.size() * 2;
        for (int i = 0; i < loopTimes; ++i) {
            StateEvent stateEvent = this.stateEvents.peek();
            if (stateEvent == null) {
                return;
            }
            try {
                LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)stateEvent.getProcessInstanceId(), (Integer)stateEvent.getTaskInstanceId());
                this.checkProcessInstance(stateEvent);
                StateEventHandler stateEventHandler = StateEventHandlerManager.getStateEventHandler(stateEvent.getType()).orElseThrow(() -> new StateEventHandleError("Cannot find handler for the given state event"));
                log.info("Begin to handle state event, {}", (Object)stateEvent);
                if (!stateEventHandler.handleStateEvent(this, stateEvent)) continue;
                this.stateEvents.remove(stateEvent);
                continue;
            }
            catch (StateEventHandleError stateEventHandleError) {
                log.error("State event handle error, will remove this event: {}", (Object)stateEvent, (Object)stateEventHandleError);
                this.stateEvents.remove(stateEvent);
                ThreadUtils.sleep((long)1000L);
                continue;
            }
            catch (StateEventHandleException stateEventHandleException) {
                log.error("State event handle error, will retry this event: {}", (Object)stateEvent, (Object)stateEventHandleException);
                ThreadUtils.sleep((long)1000L);
                continue;
            }
            catch (StateEventHandleFailure stateEventHandleFailure) {
                log.error("State event handle failed, will move event to the tail: {}", (Object)stateEvent, (Object)stateEventHandleFailure);
                this.stateEvents.remove(stateEvent);
                this.stateEvents.offer(stateEvent);
                ThreadUtils.sleep((long)1000L);
                continue;
            }
            catch (Exception e) {
                log.error("State event handle error, get a unknown exception, will retry this event: {}", (Object)stateEvent, (Object)e);
                ThreadUtils.sleep((long)1000L);
                continue;
            }
            finally {
                LogUtils.removeWorkflowAndTaskInstanceIdMDC();
            }
        }
    }

    public IWorkflowExecuteContext getWorkflowExecuteContext() {
        return this.workflowExecuteContext;
    }

    public boolean addStateEvent(StateEvent stateEvent) {
        if (this.workflowExecuteContext.getWorkflowInstance().getId().intValue() != stateEvent.getProcessInstanceId()) {
            log.info("state event would be abounded :{}", (Object)stateEvent);
            return false;
        }
        this.stateEvents.add(stateEvent);
        return true;
    }

    public int eventSize() {
        return this.stateEvents.size();
    }

    public boolean checkForceStartAndWakeUp(StateEvent stateEvent) {
        TaskGroupQueue taskGroupQueue = this.processService.loadTaskGroupQueue(stateEvent.getTaskInstanceId().intValue());
        if (taskGroupQueue.getForceStart() == Flag.YES.getCode()) {
            log.info("Begin to force start taskGroupQueue: {}", (Object)taskGroupQueue.getId());
            TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)stateEvent.getTaskInstanceId());
            DefaultTaskExecuteRunnable defaultTaskExecuteRunnable = this.taskExecuteRunnableMap.get(taskInstance.getTaskCode());
            if (defaultTaskExecuteRunnable != null) {
                defaultTaskExecuteRunnable.dispatch();
                this.processService.updateTaskGroupQueueStatus(Integer.valueOf(taskGroupQueue.getTaskId()), TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode());
                log.info("Success force start task: {}, taskGroup: {}", (Object)taskGroupQueue.getTaskName(), (Object)taskGroupQueue.getGroupId());
            } else {
                log.warn("Cannot find the TaskExecuteRunnable: {}", (Object)taskGroupQueue.getTaskName());
            }
            return true;
        }
        if (taskGroupQueue.getInQueue() == Flag.YES.getCode()) {
            log.info("Begin to wake up taskGroupQueue: {}", (Object)taskGroupQueue.getId());
            boolean acquireTaskGroup = this.processService.robTaskGroupResource(taskGroupQueue);
            if (acquireTaskGroup) {
                TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)stateEvent.getTaskInstanceId());
                this.taskExecuteRunnableMap.get(taskInstance.getTaskCode()).dispatch();
                log.info("Success wake up taskGroupQueue: {}", (Object)taskGroupQueue.getId());
                return true;
            }
            log.warn("Failed to wake up taskGroupQueue, taskGroupQueueId: {}", (Object)taskGroupQueue.getId());
            return false;
        }
        log.info("Failed to wake up the taskGroupQueue: {}, since the taskGroupQueue is not in queue, will no need to wake up.", (Object)taskGroupQueue);
        return true;
    }

    public void processTimeout() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(workflowInstance.getId().intValue());
        this.processAlertManager.sendProcessTimeoutAlert(workflowInstance, projectUser);
    }

    public void taskTimeout(TaskInstance taskInstance) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(workflowInstance.getId().intValue());
        this.processAlertManager.sendTaskTimeoutAlert(workflowInstance, taskInstance, projectUser);
    }

    public void taskFinished(TaskInstance taskInstance) throws StateEventHandleException {
        log.info("TaskInstance finished task code:{} state:{}", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getState());
        try {
            ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
            this.taskExecuteRunnableMap.remove(taskInstance.getTaskCode());
            this.stateWheelExecuteThread.removeTask4TimeoutCheck(workflowInstance, taskInstance);
            this.stateWheelExecuteThread.removeTask4RetryCheck(workflowInstance, taskInstance);
            if (taskInstance.getState().isSuccess()) {
                this.completeTaskSet.add(taskInstance.getTaskCode());
                this.mergeTaskInstanceVarPool(taskInstance);
                this.processInstanceDao.upsertProcessInstance(workflowInstance);
                if (taskInstance.getIsCache().equals((Object)Flag.YES)) {
                    this.saveCacheTaskInstance(taskInstance);
                }
                if (!workflowInstance.isBlocked()) {
                    this.submitPostNode(taskInstance.getTaskCode());
                }
            } else if (taskInstance.taskCanRetry() && !workflowInstance.getState().isReadyStop()) {
                log.info("Retry taskInstance taskInstance state: {}", (Object)taskInstance.getState());
                this.retryTaskInstance(taskInstance);
            } else if (taskInstance.getState().isFailure()) {
                this.completeTaskSet.add(taskInstance.getTaskCode());
                if (workflowInstance.getFailureStrategy() == FailureStrategy.CONTINUE && DagHelper.haveAllNodeAfterNode((Long)taskInstance.getTaskCode(), this.workflowExecuteContext.getWorkflowGraph().getDag())) {
                    this.submitPostNode(taskInstance.getTaskCode());
                } else {
                    this.errorTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
                    if (workflowInstance.getFailureStrategy() == FailureStrategy.END) {
                        this.killAllTasks();
                    }
                }
            } else if (taskInstance.getState().isFinished()) {
                this.completeTaskSet.add(taskInstance.getTaskCode());
            }
            log.info("TaskInstance finished will try to update the workflow instance state, task code:{} state:{}", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getState());
            this.updateProcessInstanceState();
            log.info(WorkflowInstanceUtils.logTaskInstanceInDetail(taskInstance));
            this.sendTaskLogOnMasterToRemoteIfNeeded(taskInstance);
        }
        catch (Exception ex) {
            log.error("Task finish failed, get a exception, will remove this taskInstance from completeTaskSet", (Throwable)ex);
            this.completeTaskSet.remove(taskInstance.getTaskCode());
            throw ex;
        }
    }

    public void releaseTaskGroup(TaskInstance taskInstance) throws RemotingException, InterruptedException {
        TaskInstance nextTaskInstance;
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (taskInstance.getTaskGroupId() <= 0) {
            log.info("The current TaskInstance: {} doesn't use taskGroup, no need to release taskGroup", (Object)taskInstance.getName());
        }
        if ((nextTaskInstance = this.processService.releaseTaskGroup(taskInstance)) == null) {
            log.info("The current TaskInstance: {} is the last taskInstance in the taskGroup, no need to wakeup next taskInstance", (Object)taskInstance.getName());
            return;
        }
        if (nextTaskInstance.getProcessInstanceId() == taskInstance.getProcessInstanceId()) {
            TaskStateEvent nextEvent = TaskStateEvent.builder().processInstanceId(workflowInstance.getId()).taskInstanceId(nextTaskInstance.getId()).type(StateEventType.WAKE_UP_TASK_GROUP).build();
            this.stateEvents.add(nextEvent);
        } else {
            ProcessInstance processInstance = this.processService.findProcessInstanceById(nextTaskInstance.getProcessInstanceId());
            this.masterRpcClient.sendSyncCommand(Host.of((String)processInstance.getHost()), new TaskWakeupRequest(processInstance.getId().intValue(), nextTaskInstance.getId().intValue()).convert2Command());
        }
        log.info("Success send wakeup message to next taskInstance: {}", (Object)nextTaskInstance.getId());
    }

    private void retryTaskInstance(TaskInstance taskInstance) throws StateEventHandleException {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (!taskInstance.taskCanRetry()) {
            return;
        }
        TaskInstance newTaskInstance = this.cloneRetryTaskInstance(taskInstance);
        if (newTaskInstance == null) {
            log.error("Retry task fail because new taskInstance is null, task code:{}, task id:{}", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getId());
            return;
        }
        this.waitToRetryTaskInstanceMap.put(newTaskInstance.getTaskCode(), newTaskInstance);
        if (!taskInstance.retryTaskIntervalOverTime()) {
            log.info("Failure task will be submitted, process id: {}, task instance code: {}, state: {}, retry times: {} / {}, interval: {}", new Object[]{workflowInstance.getId(), newTaskInstance.getTaskCode(), newTaskInstance.getState(), newTaskInstance.getRetryTimes(), newTaskInstance.getMaxRetryTimes(), newTaskInstance.getRetryInterval()});
            this.stateWheelExecuteThread.addTask4TimeoutCheck(workflowInstance, newTaskInstance);
            this.stateWheelExecuteThread.addTask4RetryCheck(workflowInstance, newTaskInstance);
        } else {
            this.addTaskToStandByList(newTaskInstance);
            this.submitStandByTask();
            this.waitToRetryTaskInstanceMap.remove(newTaskInstance.getTaskCode());
        }
    }

    public void refreshProcessInstance(int processInstanceId) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        ProcessDefinition workflowDefinition = this.workflowExecuteContext.getWorkflowDefinition();
        log.info("process instance update: {}", (Object)processInstanceId);
        ProcessInstance newProcessInstance = this.processService.findProcessInstanceById(processInstanceId);
        BeanUtils.copyProperties((Object)newProcessInstance, (Object)workflowInstance);
        ProcessDefinition newWorkflowDefinition = this.processService.findProcessDefinition(workflowInstance.getProcessDefinitionCode(), workflowInstance.getProcessDefinitionVersion());
        workflowInstance.setProcessDefinition(workflowDefinition);
        BeanUtils.copyProperties((Object)newWorkflowDefinition, (Object)workflowDefinition);
    }

    public void refreshTaskInstance(int taskInstanceId) {
        log.info("task instance update: {} ", (Object)taskInstanceId);
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskInstanceId));
        if (taskInstance == null) {
            log.error("can not find task instance, id:{}", (Object)taskInstanceId);
            return;
        }
        this.processService.packageTaskInstance(taskInstance, this.workflowExecuteContext.getWorkflowInstance());
        this.taskInstanceMap.put(taskInstance.getId(), taskInstance);
        this.taskCodeInstanceMap.put(taskInstance.getTaskCode(), taskInstance);
        this.validTaskMap.remove(taskInstance.getTaskCode());
        if (Flag.YES == taskInstance.getFlag()) {
            this.validTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
        }
    }

    public void checkProcessInstance(StateEvent stateEvent) throws StateEventHandleError {
        if (this.workflowExecuteContext.getWorkflowInstance().getId().intValue() != stateEvent.getProcessInstanceId()) {
            throw new StateEventHandleError("The event doesn't contains process instance id");
        }
    }

    public void checkTaskInstanceByStateEvent(TaskStateEvent stateEvent) throws StateEventHandleError {
        if (stateEvent.getTaskInstanceId() == null || stateEvent.getTaskInstanceId() == 0) {
            throw new StateEventHandleError("The taskInstanceId is 0");
        }
        if (!this.taskInstanceMap.containsKey(stateEvent.getTaskInstanceId())) {
            throw new StateEventHandleError("Cannot find the taskInstance from taskInstanceMap");
        }
    }

    public boolean checkTaskInstanceById(int taskInstanceId) {
        if (this.taskInstanceMap.isEmpty()) {
            return false;
        }
        return this.taskInstanceMap.containsKey(taskInstanceId);
    }

    public Optional<TaskInstance> getTaskInstance(int taskInstanceId) {
        return Optional.ofNullable(this.taskInstanceMap.get(taskInstanceId));
    }

    public Optional<TaskInstance> getTaskInstance(long taskCode) {
        return Optional.ofNullable(this.taskCodeInstanceMap.get(taskCode));
    }

    public Optional<TaskInstance> getActiveTaskInstanceByTaskCode(long taskCode) {
        Integer taskInstanceId = this.validTaskMap.get(taskCode);
        if (taskInstanceId != null) {
            return Optional.ofNullable(this.taskInstanceMap.get(taskInstanceId));
        }
        return Optional.empty();
    }

    public Optional<TaskInstance> getRetryTaskInstanceByTaskCode(long taskCode) {
        if (this.waitToRetryTaskInstanceMap.containsKey(taskCode)) {
            return Optional.ofNullable(this.waitToRetryTaskInstanceMap.get(taskCode));
        }
        return Optional.empty();
    }

    public void processBlock() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(workflowInstance.getId().intValue());
        this.processAlertManager.sendProcessBlockingAlert(workflowInstance, projectUser);
        log.info("processInstance {} block alert send successful!", (Object)workflowInstance.getId());
    }

    public boolean processComplementData() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (!this.needComplementProcess()) {
            return false;
        }
        if (workflowInstance.getState().isReadyStop() || !workflowInstance.getState().isFinished()) {
            return false;
        }
        Date scheduleDate = workflowInstance.getScheduleTime();
        if (scheduleDate == null) {
            if (CollectionUtils.isEmpty(this.complementListDate)) {
                log.info("complementListDate is empty, process complement end. process id:{}", (Object)workflowInstance.getId());
                return true;
            }
            scheduleDate = this.complementListDate.get(0);
        } else if (workflowInstance.getState().isFinished()) {
            this.endProcess();
            if (this.complementListDate.isEmpty()) {
                log.info("process complement end. process id:{}", (Object)workflowInstance.getId());
                return true;
            }
            int index = this.complementListDate.indexOf(scheduleDate);
            if (index >= this.complementListDate.size() - 1 || !workflowInstance.getState().isSuccess()) {
                log.info("process complement end. process id:{}", (Object)workflowInstance.getId());
                return true;
            }
            log.info("process complement continue. process id:{}, schedule time:{} complementListDate:{}", new Object[]{workflowInstance.getId(), workflowInstance.getScheduleTime(), this.complementListDate});
            scheduleDate = this.complementListDate.get(index + 1);
        }
        int create = this.createComplementDataCommand(scheduleDate);
        if (create > 0) {
            log.info("create complement data command successfully.");
        }
        return true;
    }

    private int createComplementDataCommand(Date scheduleDate) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        Command command = new Command();
        command.setScheduleTime(scheduleDate);
        command.setCommandType(CommandType.COMPLEMENT_DATA);
        command.setProcessDefinitionCode(workflowInstance.getProcessDefinitionCode().longValue());
        Map cmdParam = JSONUtils.toMap((String)workflowInstance.getCommandParam());
        if (cmdParam.containsKey("StartNodeIdList")) {
            cmdParam.remove("StartNodeIdList");
        }
        if (cmdParam.containsKey("complementScheduleDateList")) {
            cmdParam.replace("complementScheduleDateList", ((String)cmdParam.get("complementScheduleDateList")).substring(((String)cmdParam.get("complementScheduleDateList")).indexOf(",") + 1));
        }
        if (cmdParam.containsKey("complementStartDate")) {
            cmdParam.replace("complementStartDate", DateUtils.format((Date)scheduleDate, (String)"yyyy-MM-dd HH:mm:ss", null));
        }
        command.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
        command.setTaskDependType(workflowInstance.getTaskDependType());
        command.setFailureStrategy(workflowInstance.getFailureStrategy());
        command.setWarningType(workflowInstance.getWarningType());
        command.setWarningGroupId(workflowInstance.getWarningGroupId());
        command.setStartTime(new Date());
        command.setExecutorId(workflowInstance.getExecutorId());
        command.setUpdateTime(new Date());
        command.setProcessInstancePriority(workflowInstance.getProcessInstancePriority());
        command.setWorkerGroup(workflowInstance.getWorkerGroup());
        command.setEnvironmentCode(workflowInstance.getEnvironmentCode());
        command.setDryRun(workflowInstance.getDryRun());
        command.setProcessInstanceId(0);
        command.setProcessDefinitionVersion(workflowInstance.getProcessDefinitionVersion());
        command.setTestFlag(workflowInstance.getTestFlag());
        int create = this.commandService.createCommand(command);
        this.processService.saveCommandTrigger(command.getId(), workflowInstance.getId());
        return create;
    }

    private boolean needComplementProcess() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        return workflowInstance.isComplementData() && Flag.NO == workflowInstance.getIsSubProcess();
    }

    @Override
    public WorkflowStartStatus startWorkflow() {
        try {
            ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
            LogUtils.setWorkflowInstanceIdMDC((Integer)workflowInstance.getId());
            if (this.isStart()) {
                log.warn("The workflow has already been started, current state: {}", (Object)this.workflowRunnableStatus);
                WorkflowStartStatus workflowStartStatus = WorkflowStartStatus.DUPLICATED_SUBMITTED;
                return workflowStartStatus;
            }
            if (this.workflowRunnableStatus == WorkflowRunnableStatus.CREATED) {
                this.initTaskQueue();
                this.workflowRunnableStatus = WorkflowRunnableStatus.INITIALIZE_QUEUE;
                log.info("workflowStatue changed to :{}", (Object)this.workflowRunnableStatus);
            }
            if (this.workflowRunnableStatus == WorkflowRunnableStatus.INITIALIZE_QUEUE) {
                this.submitPostNode(null);
                this.workflowRunnableStatus = WorkflowRunnableStatus.STARTED;
                log.info("workflowStatue changed to :{}", (Object)this.workflowRunnableStatus);
            }
            WorkflowStartStatus workflowStartStatus = WorkflowStartStatus.SUCCESS;
            return workflowStartStatus;
        }
        catch (Exception e) {
            log.error("Start workflow error", (Throwable)e);
            WorkflowStartStatus workflowStartStatus = WorkflowStartStatus.FAILED;
            return workflowStartStatus;
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    public void endProcess() {
        this.stateEvents.clear();
        ProcessDefinition workflowDefinition = this.workflowExecuteContext.getWorkflowDefinition();
        if (workflowDefinition.getExecutionType().typeIsSerialWait() || workflowDefinition.getExecutionType().typeIsSerialPriority()) {
            this.checkSerialProcess(workflowDefinition);
        }
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(workflowInstance.getId().intValue());
        this.processAlertManager.sendAlertProcessInstance(workflowInstance, this.getValidTaskList(), projectUser);
        if (workflowInstance.getState().isSuccess()) {
            this.processAlertManager.closeAlert(workflowInstance);
        }
        if (this.checkTaskQueue()) {
            this.processService.releaseAllTaskGroup(workflowInstance.getId().intValue());
        }
        log.info(WorkflowInstanceUtils.logWorkflowInstanceInDetails(workflowInstance));
    }

    public void checkSerialProcess(ProcessDefinition processDefinition) {
        Map paramsMap;
        Map commandStartParamsMap;
        ProcessInstance nextProcessInstance;
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        int nextInstanceId = workflowInstance.getNextProcessInstanceId();
        if (nextInstanceId == 0) {
            nextProcessInstance = this.processService.loadNextProcess4Serial(workflowInstance.getProcessDefinition().getCode(), WorkflowExecutionStatus.SERIAL_WAIT.getCode(), workflowInstance.getId().intValue());
            if (nextProcessInstance == null) {
                return;
            }
            ProcessInstance nextReadyStopProcessInstance = this.processService.loadNextProcess4Serial(workflowInstance.getProcessDefinition().getCode(), WorkflowExecutionStatus.READY_STOP.getCode(), workflowInstance.getId().intValue());
            if (processDefinition.getExecutionType().typeIsSerialPriority() && nextReadyStopProcessInstance != null) {
                return;
            }
            nextInstanceId = nextProcessInstance.getId();
        }
        if ((nextProcessInstance = this.processService.findProcessInstanceById(nextInstanceId)).getState().isFinished() || nextProcessInstance.getState().isRunning()) {
            return;
        }
        HashMap<String, Object> cmdParam = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)nextProcessInstance.getCommandParam()) && MapUtils.isNotEmpty((Map)(commandStartParamsMap = JSONUtils.toMap((String)nextProcessInstance.getCommandParam()))) && MapUtils.isNotEmpty((Map)(paramsMap = JSONUtils.toMap((String)((String)commandStartParamsMap.get("StartParams")))))) {
            cmdParam.put("StartParams", JSONUtils.toJsonString((Object)paramsMap));
        }
        cmdParam.put("ProcessInstanceId", nextInstanceId);
        Command command = new Command();
        command.setCommandType(CommandType.RECOVER_SERIAL_WAIT);
        command.setProcessInstanceId(nextProcessInstance.getId().intValue());
        command.setProcessDefinitionCode(processDefinition.getCode());
        command.setProcessDefinitionVersion(processDefinition.getVersion());
        command.setCommandParam(JSONUtils.toJsonString(cmdParam));
        this.commandService.createCommand(command);
    }

    private void initTaskQueue() throws StateEventHandleException, CronParseException {
        Map cmdParam;
        this.taskFailedSubmit = false;
        this.taskExecuteRunnableMap.clear();
        this.dependFailedTaskSet.clear();
        this.completeTaskSet.clear();
        this.errorTaskMap.clear();
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        ProcessDefinition workflowDefinition = this.workflowExecuteContext.getWorkflowDefinition();
        if (!this.isNewProcessInstance()) {
            log.info("The workflowInstance is not a newly running instance, runtimes: {}, recover flag: {}", (Object)workflowInstance.getRunTimes(), (Object)workflowInstance.getRecovery());
            List validTaskInstanceList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId(), workflowInstance.getTestFlag());
            for (TaskInstance task : validTaskInstanceList) {
                LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)task.getProcessInstanceId(), (Integer)task.getId());
                Throwable throwable = null;
                try {
                    log.info("Check the taskInstance from a exist workflowInstance, existTaskInstanceCode: {}, taskInstanceStatus: {}", (Object)task.getTaskCode(), (Object)task.getState());
                    if (this.validTaskMap.containsKey(task.getTaskCode())) {
                        log.warn("Have same taskCode taskInstance when init task queue, need to check taskExecutionStatus, taskCode:{}", (Object)task.getTaskCode());
                        int oldTaskInstanceId = this.validTaskMap.get(task.getTaskCode());
                        TaskInstance oldTaskInstance = this.taskInstanceMap.get(oldTaskInstanceId);
                        if (!oldTaskInstance.getState().isFinished() && task.getState().isFinished()) {
                            task.setFlag(Flag.NO);
                            this.taskInstanceDao.updateById((Object)task);
                            continue;
                        }
                    }
                    this.processService.packageTaskInstance(task, workflowInstance);
                    this.validTaskMap.put(task.getTaskCode(), task.getId());
                    this.taskInstanceMap.put(task.getId(), task);
                    this.taskCodeInstanceMap.put(task.getTaskCode(), task);
                    if (task.isTaskComplete()) {
                        log.info("TaskInstance is already complete.");
                        this.completeTaskSet.add(task.getTaskCode());
                        continue;
                    }
                    if (task.isConditionsTask() || DagHelper.haveConditionsAfterNode((Long)task.getTaskCode(), this.workflowExecuteContext.getWorkflowGraph().getDag())) continue;
                    if (task.taskCanRetry()) {
                        if (task.getState().isNeedFaultTolerance()) {
                            log.info("TaskInstance needs fault tolerance, will be added to standby list.");
                            task.setFlag(Flag.NO);
                            this.taskInstanceDao.updateById((Object)task);
                            TaskInstance tolerantTaskInstance = this.cloneTolerantTaskInstance(task);
                            this.addTaskToStandByList(tolerantTaskInstance);
                            continue;
                        }
                        log.info("Retry taskInstance, taskState: {}", (Object)task.getState());
                        this.retryTaskInstance(task);
                        continue;
                    }
                    if (!task.getState().isFailure()) continue;
                    this.errorTaskMap.put(task.getTaskCode(), task.getId());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (mdcAutoClosableContext == null) continue;
                    if (throwable != null) {
                        try {
                            mdcAutoClosableContext.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    mdcAutoClosableContext.close();
                }
            }
            this.clearDataIfExecuteTask();
        } else {
            log.info("The current workflowInstance is a newly running workflowInstance");
        }
        if (workflowInstance.isComplementData() && this.complementListDate.isEmpty() && (cmdParam = JSONUtils.toMap((String)workflowInstance.getCommandParam())) != null) {
            this.setGlobalParamIfCommanded(workflowDefinition, cmdParam);
            Date start = null;
            Date end = null;
            if (cmdParam.containsKey("complementStartDate") && cmdParam.containsKey("complementEndDate")) {
                start = DateUtils.stringToDate((String)((String)cmdParam.get("complementStartDate")));
                end = DateUtils.stringToDate((String)((String)cmdParam.get("complementEndDate")));
            }
            if (this.complementListDate.isEmpty() && this.needComplementProcess()) {
                if (start != null && end != null) {
                    List schedules = this.processService.queryReleaseSchedulerListByProcessDefinitionCode(workflowInstance.getProcessDefinitionCode().longValue());
                    this.complementListDate = CronUtils.getSelfFireDateList((Date)start, (Date)end, (List)schedules);
                }
                if (cmdParam.containsKey("complementScheduleDateList")) {
                    this.complementListDate = CronUtils.getSelfScheduleDateList((Map)cmdParam);
                }
                log.info(" process definition code:{} complement data: {}", (Object)workflowInstance.getProcessDefinitionCode(), this.complementListDate);
                if (!this.complementListDate.isEmpty() && Flag.NO == workflowInstance.getIsSubProcess()) {
                    workflowInstance.setScheduleTime(this.complementListDate.get(0));
                    String globalParams = this.curingParamsService.curingGlobalParams(workflowInstance.getId(), workflowDefinition.getGlobalParamMap(), workflowDefinition.getGlobalParamList(), CommandType.COMPLEMENT_DATA, workflowInstance.getScheduleTime(), (String)cmdParam.get("schedule_timezone"));
                    workflowInstance.setGlobalParams(globalParams);
                    this.processInstanceDao.updateById((Object)workflowInstance);
                }
            }
        }
        log.info("Initialize task queue, dependFailedTaskSet: {}, completeTaskSet: {}, errorTaskMap: {}", new Object[]{this.dependFailedTaskSet, this.completeTaskSet, this.errorTaskMap});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeTask(TaskInstance taskInstance) {
        try {
            ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
            this.processService.packageTaskInstance(taskInstance, workflowInstance);
            if (!this.processService.submitTask(workflowInstance, taskInstance)) {
                log.error("Submit standby task: {} failed", (Object)taskInstance.getName());
                return true;
            }
            try (LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setTaskInstanceIdMDC((Integer)taskInstance.getId());){
                boolean acquireTaskGroup;
                DefaultTaskExecuteRunnable taskExecuteRunnable = this.defaultTaskExecuteRunnableFactory.createTaskExecuteRunnable(taskInstance);
                if (this.validTaskMap.containsKey(taskInstance.getTaskCode())) {
                    int oldTaskInstanceId = this.validTaskMap.get(taskInstance.getTaskCode());
                    if (taskInstance.getId() != oldTaskInstanceId) {
                        TaskInstance oldTaskInstance = this.taskInstanceMap.get(oldTaskInstanceId);
                        oldTaskInstance.setFlag(Flag.NO);
                        this.taskInstanceDao.updateById((Object)oldTaskInstance);
                        this.validTaskMap.remove(taskInstance.getTaskCode());
                        this.taskExecuteRunnableMap.remove(taskInstance.getTaskCode());
                    }
                }
                this.validTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
                this.taskInstanceMap.put(taskInstance.getId(), taskInstance);
                this.taskCodeInstanceMap.put(taskInstance.getTaskCode(), taskInstance);
                this.taskExecuteRunnableMap.put(taskInstance.getTaskCode(), taskExecuteRunnable);
                int taskGroupId = taskInstance.getTaskGroupId();
                if (taskGroupId > 0 && !(acquireTaskGroup = this.processService.acquireTaskGroup(taskInstance.getId().intValue(), taskInstance.getName(), taskGroupId, taskInstance.getProcessInstanceId(), taskInstance.getTaskGroupPriority()))) {
                    log.info("Submitted task will not be dispatch right now because the first time to try to acquire task group failed, taskInstanceName: {}, taskGroupId: {}", (Object)taskInstance.getName(), (Object)taskGroupId);
                    boolean bl2 = true;
                    return bl2;
                }
                this.tryToDispatchTaskInstance(taskInstance, taskExecuteRunnable);
                this.stateWheelExecuteThread.addTask4TimeoutCheck(workflowInstance, taskInstance);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("Submit standby task {} error", (Object)taskInstance.getName(), (Object)e);
            return false;
        }
    }

    @VisibleForTesting
    void tryToDispatchTaskInstance(TaskInstance taskInstance, TaskExecuteRunnable taskExecuteRunnable) {
        if (!taskInstance.getState().isFinished()) {
            taskExecuteRunnable.dispatch();
        } else {
            if (this.workflowExecuteContext.getWorkflowInstance().isBlocked()) {
                TaskStateEvent processBlockEvent = TaskStateEvent.builder().processInstanceId(this.workflowExecuteContext.getWorkflowInstance().getId()).taskInstanceId(taskInstance.getId()).status(taskInstance.getState()).type(StateEventType.PROCESS_BLOCKED).build();
                this.stateEvents.add(processBlockEvent);
            }
            TaskStateEvent taskStateChangeEvent = TaskStateEvent.builder().processInstanceId(this.workflowExecuteContext.getWorkflowInstance().getId()).taskInstanceId(taskInstance.getId()).status(taskInstance.getState()).type(StateEventType.TASK_STATE_CHANGE).build();
            this.stateEvents.add(taskStateChangeEvent);
        }
    }

    private TaskInstance findTaskIfExists(Long taskCode, int taskVersion) {
        List<TaskInstance> validTaskInstanceList = this.getValidTaskList();
        for (TaskInstance taskInstance : validTaskInstanceList) {
            if (taskInstance.getTaskCode() != taskCode.longValue() || taskInstance.getTaskDefinitionVersion() != taskVersion) continue;
            return taskInstance;
        }
        return null;
    }

    private TaskInstance createTaskInstance(ProcessInstance processInstance, TaskNode taskNode) {
        TaskInstance taskInstance = this.findTaskIfExists(taskNode.getCode(), taskNode.getVersion());
        if (taskInstance != null) {
            return taskInstance;
        }
        return this.newTaskInstance(processInstance, taskNode);
    }

    public TaskInstance cloneRetryTaskInstance(TaskInstance taskInstance) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        TaskNode taskNode = this.workflowExecuteContext.getWorkflowGraph().getTaskNodeByCode(taskInstance.getTaskCode());
        TaskInstance newTaskInstance = this.newTaskInstance(workflowInstance, taskNode);
        newTaskInstance.setTaskDefine(taskInstance.getTaskDefine());
        newTaskInstance.setProcessDefine(taskInstance.getProcessDefine());
        newTaskInstance.setProcessInstance(workflowInstance);
        newTaskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
        newTaskInstance.setState(taskInstance.getState());
        newTaskInstance.setEndTime(taskInstance.getEndTime());
        newTaskInstance.setVarPool(taskInstance.getVarPool());
        if (taskInstance.getState() == TaskExecutionStatus.NEED_FAULT_TOLERANCE) {
            newTaskInstance.setAppLink(taskInstance.getAppLink());
        }
        return newTaskInstance;
    }

    public TaskInstance cloneTolerantTaskInstance(TaskInstance taskInstance) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        TaskNode taskNode = this.workflowExecuteContext.getWorkflowGraph().getTaskNodeByCode(taskInstance.getTaskCode());
        TaskInstance newTaskInstance = this.newTaskInstance(workflowInstance, taskNode);
        newTaskInstance.setTaskDefine(taskInstance.getTaskDefine());
        newTaskInstance.setProcessDefine(taskInstance.getProcessDefine());
        newTaskInstance.setProcessInstance(workflowInstance);
        newTaskInstance.setRetryTimes(taskInstance.getRetryTimes());
        newTaskInstance.setState(taskInstance.getState());
        newTaskInstance.setAppLink(taskInstance.getAppLink());
        newTaskInstance.setVarPool(taskInstance.getVarPool());
        return newTaskInstance;
    }

    public TaskInstance newTaskInstance(ProcessInstance processInstance, TaskNode taskNode) {
        Environment environment;
        Long taskEnvironmentCode;
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setTaskCode(taskNode.getCode());
        taskInstance.setTaskDefinitionVersion(taskNode.getVersion());
        taskInstance.setName(taskNode.getName());
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        taskInstance.setProcessInstanceId(processInstance.getId().intValue());
        taskInstance.setProcessInstanceName(processInstance.getName());
        taskInstance.setProjectCode(processInstance.getProjectCode());
        taskInstance.setTaskType(taskNode.getType().toUpperCase());
        taskInstance.setAlertFlag(Flag.NO);
        taskInstance.setStartTime(null);
        taskInstance.setTestFlag(processInstance.getTestFlag());
        taskInstance.setFlag(Flag.YES);
        taskInstance.setDryRun(processInstance.getDryRun());
        taskInstance.setRetryTimes(0);
        taskInstance.setMaxRetryTimes(taskNode.getMaxRetryTimes());
        taskInstance.setRetryInterval(taskNode.getRetryInterval());
        taskInstance.setTaskParams(taskNode.getTaskParams());
        taskInstance.setTaskGroupId(taskNode.getTaskGroupId());
        taskInstance.setTaskGroupPriority(taskNode.getTaskGroupPriority());
        taskInstance.setCpuQuota(taskNode.getCpuQuota());
        taskInstance.setMemoryMax(taskNode.getMemoryMax());
        taskInstance.setIsCache(taskNode.getIsCache() == Flag.YES.getCode() ? Flag.YES : Flag.NO);
        if (taskNode.getTaskInstancePriority() == null) {
            taskInstance.setTaskInstancePriority(Priority.MEDIUM);
        } else {
            taskInstance.setTaskInstancePriority(taskNode.getTaskInstancePriority());
        }
        String processWorkerGroup = processInstance.getWorkerGroup();
        processWorkerGroup = StringUtils.isBlank((CharSequence)processWorkerGroup) ? "default" : processWorkerGroup;
        String taskWorkerGroup = StringUtils.isBlank((CharSequence)taskNode.getWorkerGroup()) ? processWorkerGroup : taskNode.getWorkerGroup();
        Long processEnvironmentCode = Objects.isNull(processInstance.getEnvironmentCode()) ? -1L : processInstance.getEnvironmentCode();
        Long l = taskEnvironmentCode = Objects.isNull(taskNode.getEnvironmentCode()) ? processEnvironmentCode : taskNode.getEnvironmentCode();
        if (!processWorkerGroup.equals("default") && taskWorkerGroup.equals("default")) {
            taskInstance.setWorkerGroup(processWorkerGroup);
            taskInstance.setEnvironmentCode(processEnvironmentCode);
        } else {
            taskInstance.setWorkerGroup(taskWorkerGroup);
            taskInstance.setEnvironmentCode(taskEnvironmentCode);
        }
        if (!taskInstance.getEnvironmentCode().equals(-1L) && Objects.nonNull(environment = this.processService.findEnvironmentByCode(taskInstance.getEnvironmentCode())) && StringUtils.isNotEmpty((CharSequence)environment.getConfig())) {
            taskInstance.setEnvironmentConfig(environment.getConfig());
        }
        taskInstance.setDelayTime(taskNode.getDelayTime());
        taskInstance.setTaskExecuteType(taskNode.getTaskExecuteType());
        return taskInstance;
    }

    public void getPreVarPool(TaskInstance taskInstance, Set<Long> preTask) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        HashMap<String, Property> allProperty = new HashMap<String, Property>();
        HashMap<String, TaskInstance> allTaskInstance = new HashMap<String, TaskInstance>();
        if (CollectionUtils.isNotEmpty(preTask)) {
            for (Long preTaskCode : preTask) {
                String preVarPool;
                TaskInstance preTaskInstance;
                Integer taskId;
                Optional<TaskInstance> existTaskInstanceOptional = this.getTaskInstance(preTaskCode);
                if (!existTaskInstanceOptional.isPresent() || (taskId = existTaskInstanceOptional.get().getId()) == null || (preTaskInstance = this.taskInstanceMap.get(taskId)) == null || !StringUtils.isNotEmpty((CharSequence)(preVarPool = preTaskInstance.getVarPool()))) continue;
                List properties = JSONUtils.toList((String)preVarPool, Property.class);
                for (Property info : properties) {
                    this.setVarPoolValue(allProperty, allTaskInstance, preTaskInstance, info);
                }
            }
            if (allProperty.size() > 0) {
                taskInstance.setVarPool(JSONUtils.toJsonString(allProperty.values()));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)workflowInstance.getVarPool())) {
            taskInstance.setVarPool(workflowInstance.getVarPool());
        }
    }

    public Collection<TaskInstance> getAllTaskInstances() {
        return this.taskInstanceMap.values();
    }

    private void setVarPoolValue(Map<String, Property> allProperty, Map<String, TaskInstance> allTaskInstance, TaskInstance preTaskInstance, Property thisProperty) {
        thisProperty.setDirect(Direct.IN);
        String proName = thisProperty.getProp();
        if (allProperty.containsKey(proName)) {
            Property otherPro = allProperty.get(proName);
            if (StringUtils.isEmpty((CharSequence)thisProperty.getValue())) {
                allProperty.put(proName, otherPro);
            } else if (StringUtils.isNotEmpty((CharSequence)otherPro.getValue())) {
                TaskInstance otherTask = allTaskInstance.get(proName);
                if (otherTask.getEndTime().getTime() > preTaskInstance.getEndTime().getTime()) {
                    allProperty.put(proName, thisProperty);
                    allTaskInstance.put(proName, preTaskInstance);
                } else {
                    allProperty.put(proName, otherPro);
                }
            } else {
                allProperty.put(proName, thisProperty);
                allTaskInstance.put(proName, preTaskInstance);
            }
        } else {
            allProperty.put(proName, thisProperty);
            allTaskInstance.put(proName, preTaskInstance);
        }
    }

    private Map<Long, TaskInstance> getCompleteTaskInstanceMap() {
        HashMap<Long, TaskInstance> completeTaskInstanceMap = new HashMap<Long, TaskInstance>();
        this.completeTaskSet.forEach(taskCode -> {
            Optional<TaskInstance> existTaskInstanceOptional = this.getTaskInstance((long)taskCode);
            if (existTaskInstanceOptional.isPresent()) {
                TaskInstance taskInstance = existTaskInstanceOptional.get();
                completeTaskInstanceMap.put((Long)taskCode, taskInstance);
            } else {
                log.warn("Cannot find the taskInstance from taskInstanceMap, taskConde: {}", taskCode);
            }
        });
        return completeTaskInstanceMap;
    }

    private List<TaskInstance> getValidTaskList() {
        ArrayList<TaskInstance> validTaskInstanceList = new ArrayList<TaskInstance>();
        for (Integer taskInstanceId : this.validTaskMap.values()) {
            validTaskInstanceList.add(this.taskInstanceMap.get(taskInstanceId));
        }
        return validTaskInstanceList;
    }

    private void submitPostNode(Long parentNodeCode) throws StateEventHandleException {
        TaskInstance endTaskInstance;
        String taskInstanceVarPool;
        Optional<TaskInstance> existTaskInstanceOptional;
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        DAG<Long, TaskNode, TaskNodeRelation> dag = this.workflowExecuteContext.getWorkflowGraph().getDag();
        Set submitTaskNodeList = DagHelper.parsePostNodes((Long)parentNodeCode, this.skipTaskNodeMap, dag, this.getCompleteTaskInstanceMap());
        ArrayList<TaskInstance> taskInstances = new ArrayList<TaskInstance>();
        for (Long taskNode : submitTaskNodeList) {
            TaskNode taskNodeObject = (TaskNode)dag.getNode((Object)taskNode);
            Optional<TaskInstance> existTaskInstanceOptional2 = this.getTaskInstance(taskNodeObject.getCode());
            if (existTaskInstanceOptional2.isPresent()) {
                TaskInstance existTaskInstance = existTaskInstanceOptional2.get();
                TaskExecutionStatus state = existTaskInstance.getState();
                if (state == TaskExecutionStatus.RUNNING_EXECUTION || state == TaskExecutionStatus.DISPATCH || state == TaskExecutionStatus.SUBMITTED_SUCCESS) {
                    if (state != TaskExecutionStatus.SUBMITTED_SUCCESS && this.tryToTakeOverTaskInstance(existTaskInstance)) {
                        log.info("Success take over task {}", (Object)existTaskInstance.getName());
                        continue;
                    }
                    existTaskInstance.setFlag(Flag.NO);
                    existTaskInstance.setState(TaskExecutionStatus.NEED_FAULT_TOLERANCE);
                    this.validTaskMap.remove(existTaskInstance.getTaskCode());
                    this.taskInstanceDao.updateById((Object)existTaskInstance);
                    existTaskInstance = this.cloneTolerantTaskInstance(existTaskInstance);
                    log.info("task {} cannot be take over will generate a tolerant task instance", (Object)existTaskInstance.getName());
                }
                taskInstances.add(existTaskInstance);
                continue;
            }
            taskInstances.add(this.createTaskInstance(workflowInstance, taskNodeObject));
        }
        if (parentNodeCode != null && dag.getEndNode().contains(parentNodeCode) && (existTaskInstanceOptional = this.getTaskInstance(parentNodeCode)).isPresent() && StringUtils.isNotEmpty((CharSequence)(taskInstanceVarPool = (endTaskInstance = this.taskInstanceMap.get(existTaskInstanceOptional.get().getId())).getVarPool()))) {
            HashSet taskProperties = new HashSet(JSONUtils.toList((String)taskInstanceVarPool, Property.class));
            String processInstanceVarPool = workflowInstance.getVarPool();
            ArrayList processGlobalParams = new ArrayList(JSONUtils.toList((String)workflowInstance.getGlobalParams(), Property.class));
            Map<String, Direct> oldProcessGlobalParamsMap = processGlobalParams.stream().collect(Collectors.toMap(Property::getProp, Property::getDirect));
            Set processVarPoolOut = taskProperties.stream().filter(property -> property.getDirect().equals((Object)Direct.OUT) && oldProcessGlobalParamsMap.containsKey(property.getProp()) && ((Direct)oldProcessGlobalParamsMap.get(property.getProp())).equals((Object)Direct.OUT)).collect(Collectors.toSet());
            Set taskVarPoolIn = taskProperties.stream().filter(property -> property.getDirect().equals((Object)Direct.IN)).collect(Collectors.toSet());
            if (StringUtils.isNotEmpty((CharSequence)processInstanceVarPool)) {
                Set<Object> properties = new HashSet(JSONUtils.toList((String)processInstanceVarPool, Property.class));
                Set newProcessVarPoolKeys = taskProperties.stream().map(Property::getProp).collect(Collectors.toSet());
                properties = properties.stream().filter(property -> !newProcessVarPoolKeys.contains(property.getProp())).collect(Collectors.toSet());
                properties.addAll(processVarPoolOut);
                properties.addAll(taskVarPoolIn);
                workflowInstance.setVarPool(JSONUtils.toJsonString(properties));
            } else {
                HashSet varPool = new HashSet();
                varPool.addAll(taskVarPoolIn);
                varPool.addAll(processVarPoolOut);
                workflowInstance.setVarPool(JSONUtils.toJsonString(varPool));
            }
        }
        for (TaskInstance task : taskInstances) {
            if (this.readyToSubmitTaskQueue.contains(task)) {
                log.warn("Task is already at submit queue, taskInstanceName: {}", (Object)task.getName());
                continue;
            }
            if (task.getId() != null && this.completeTaskSet.contains(task.getTaskCode())) {
                log.info("Task has already run success, taskName: {}", (Object)task.getName());
                continue;
            }
            if (task.getState().isKill()) {
                log.info("Task is be stopped, the state is {}, taskInstanceId: {}", (Object)task.getState(), (Object)task.getId());
                continue;
            }
            this.addTaskToStandByList(task);
        }
        this.submitStandByTask();
        this.updateProcessInstanceState();
    }

    private boolean tryToTakeOverTaskInstance(TaskInstance taskInstance) {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (TaskUtils.isMasterTask(taskInstance.getTaskType())) {
            return false;
        }
        try {
            Message message = this.masterRpcClient.sendSyncCommand(Host.of((String)taskInstance.getHost()), new WorkflowHostChangeRequest(taskInstance.getId().intValue(), this.masterConfig.getMasterAddress()).convert2Command());
            if (message == null) {
                log.error("Takeover task instance failed, the worker {} might not be alive, will try to create a new task instance", (Object)taskInstance.getHost());
                return false;
            }
            WorkflowHostChangeResponse workflowHostChangeResponse = (WorkflowHostChangeResponse)JSONUtils.parseObject((byte[])message.getBody(), WorkflowHostChangeResponse.class);
            if (workflowHostChangeResponse == null || !workflowHostChangeResponse.isSuccess()) {
                log.error("Takeover task instance failed, receive a failed response from worker: {}, will try to create a new task instance", (Object)taskInstance.getHost());
                return false;
            }
            this.taskExecuteRunnableMap.put(taskInstance.getTaskCode(), this.defaultTaskExecuteRunnableFactory.createTaskExecuteRunnable(taskInstance));
            this.taskInstanceMap.put(taskInstance.getId(), taskInstance);
            this.taskCodeInstanceMap.put(taskInstance.getTaskCode(), taskInstance);
            this.stateWheelExecuteThread.addTask4TimeoutCheck(workflowInstance, taskInstance);
            this.stateWheelExecuteThread.addTask4RetryCheck(workflowInstance, taskInstance);
            return true;
        }
        catch (InterruptedException | RemotingException | TaskExecuteRunnableCreateException e) {
            log.error("Takeover task instance failed, the worker {} might not be alive, will try to create a new task instance", (Object)taskInstance.getHost(), (Object)e);
            return false;
        }
    }

    private DependResult isTaskDepsComplete(Long taskCode) {
        DAG<Long, TaskNode, TaskNodeRelation> dag = this.workflowExecuteContext.getWorkflowGraph().getDag();
        Collection startNodes = dag.getBeginNode();
        if (startNodes.contains(taskCode)) {
            return DependResult.SUCCESS;
        }
        TaskNode taskNode = (TaskNode)dag.getNode((Object)taskCode);
        ArrayList<Long> indirectDepCodeList = new ArrayList<Long>();
        this.setIndirectDepList(taskCode, indirectDepCodeList);
        for (Long depsNode : indirectDepCodeList) {
            if (!dag.containsNode((Object)depsNode) || this.skipTaskNodeMap.containsKey(depsNode)) continue;
            if (!this.completeTaskSet.contains(depsNode)) {
                return DependResult.WAITING;
            }
            Optional<TaskInstance> existTaskInstanceOptional = this.getTaskInstance(depsNode);
            if (!existTaskInstanceOptional.isPresent()) {
                return DependResult.NON_EXEC;
            }
            TaskExecutionStatus depTaskState = this.taskInstanceMap.get(existTaskInstanceOptional.get().getId()).getState();
            if (depTaskState.isKill()) {
                return DependResult.NON_EXEC;
            }
            if (taskNode.isBlockingTask() || taskNode.isConditionsTask() || this.dependTaskSuccess(depsNode, taskCode)) continue;
            return DependResult.FAILED;
        }
        log.info("The dependTasks of task all success, currentTaskCode: {}, dependTaskCodes: {}", (Object)taskCode, (Object)Arrays.toString(this.completeTaskSet.toArray()));
        return DependResult.SUCCESS;
    }

    private void setIndirectDepList(Long taskCode, List<Long> indirectDepCodeList) {
        IWorkflowGraph workflowGraph = this.workflowExecuteContext.getWorkflowGraph();
        DAG<Long, TaskNode, TaskNodeRelation> dag = workflowGraph.getDag();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)taskCode);
        if (taskNode == null) {
            return;
        }
        for (Long depsNode : taskNode.getDepList()) {
            if (workflowGraph.isForbiddenTask(depsNode)) {
                this.setIndirectDepList(depsNode, indirectDepCodeList);
                continue;
            }
            indirectDepCodeList.add(depsNode);
        }
    }

    private boolean dependTaskSuccess(Long dependNodeCode, Long nextNodeCode) {
        DAG<Long, TaskNode, TaskNodeRelation> dag = this.workflowExecuteContext.getWorkflowGraph().getDag();
        TaskNode dependentNode = (TaskNode)dag.getNode((Object)dependNodeCode);
        if (dependentNode.isConditionsTask()) {
            List nextTaskList = DagHelper.parseConditionTask((Long)dependNodeCode, this.skipTaskNodeMap, dag, this.getCompleteTaskInstanceMap());
            if (!nextTaskList.contains(nextNodeCode)) {
                log.info("DependTask is a condition task, and its next condition branch does not hava current task, dependTaskCode: {}, currentTaskCode: {}", (Object)dependNodeCode, (Object)nextNodeCode);
                return false;
            }
            return true;
        }
        if (dependentNode.isSwitchTask()) {
            TaskInstance dependentTaskInstance = this.taskInstanceMap.get(this.validTaskMap.get(dependentNode.getCode()));
            SwitchParameters switchParameters = dependentTaskInstance.getSwitchDependency();
            return ((SwitchResultVo)switchParameters.getDependTaskList().get(switchParameters.getResultConditionLocation())).getNextNode().contains(nextNodeCode);
        }
        Optional<TaskInstance> existTaskInstanceOptional = this.getTaskInstance(dependNodeCode);
        if (!existTaskInstanceOptional.isPresent()) {
            return false;
        }
        TaskExecutionStatus depTaskState = existTaskInstanceOptional.get().getState();
        return !depTaskState.isFailure();
    }

    private List<TaskInstance> getCompleteTaskByState(TaskExecutionStatus state) {
        ArrayList<TaskInstance> resultList = new ArrayList<TaskInstance>();
        this.completeTaskSet.forEach(taskCode -> {
            TaskInstance taskInstance;
            Optional<TaskInstance> existTaskInstanceOptional = this.getTaskInstance((long)taskCode);
            if (existTaskInstanceOptional.isPresent() && (taskInstance = existTaskInstanceOptional.get()).getState() == state) {
                resultList.add(taskInstance);
            }
        });
        return resultList;
    }

    private WorkflowExecutionStatus runningState(WorkflowExecutionStatus state) {
        if (state == WorkflowExecutionStatus.READY_STOP || state == WorkflowExecutionStatus.READY_PAUSE || state == WorkflowExecutionStatus.READY_BLOCK || state == WorkflowExecutionStatus.DELAY_EXECUTION) {
            return state;
        }
        return WorkflowExecutionStatus.RUNNING_EXECUTION;
    }

    private boolean hasFailedTask() {
        if (this.taskFailedSubmit) {
            return true;
        }
        if (this.errorTaskMap.size() > 0) {
            return true;
        }
        return this.dependFailedTaskSet.size() > 0;
    }

    private boolean processFailed() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (this.hasFailedTask()) {
            log.info("The current process has failed task, the current process failed");
            if (workflowInstance.getFailureStrategy() == FailureStrategy.END) {
                return true;
            }
            if (workflowInstance.getFailureStrategy() == FailureStrategy.CONTINUE) {
                return this.readyToSubmitTaskQueue.size() == 0 && this.taskExecuteRunnableMap.size() == 0 && this.waitToRetryTaskInstanceMap.size() == 0;
            }
        }
        return false;
    }

    private WorkflowExecutionStatus processReadyPause() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (this.hasRetryTaskInStandBy()) {
            return WorkflowExecutionStatus.FAILURE;
        }
        List<TaskInstance> pauseList = this.getCompleteTaskByState(TaskExecutionStatus.PAUSE);
        if (CollectionUtils.isNotEmpty(pauseList) || workflowInstance.isBlocked() || !this.isComplementEnd() || this.readyToSubmitTaskQueue.size() > 0) {
            return WorkflowExecutionStatus.PAUSE;
        }
        return WorkflowExecutionStatus.SUCCESS;
    }

    private WorkflowExecutionStatus processReadyBlock() {
        if (this.taskExecuteRunnableMap.size() > 0) {
            for (DefaultTaskExecuteRunnable taskExecuteRunnable : this.taskExecuteRunnableMap.values()) {
                if ("BLOCKING".equals(taskExecuteRunnable.getTaskInstance().getTaskType())) continue;
                taskExecuteRunnable.pause();
            }
        }
        if (this.readyToSubmitTaskQueue.size() > 0) {
            Iterator iter = this.readyToSubmitTaskQueue.iterator();
            while (iter.hasNext()) {
                ((TaskInstance)iter.next()).setState(TaskExecutionStatus.PAUSE);
            }
        }
        return WorkflowExecutionStatus.BLOCK;
    }

    private WorkflowExecutionStatus getProcessInstanceState(ProcessInstance instance) {
        WorkflowExecutionStatus state = instance.getState();
        if (this.taskExecuteRunnableMap.size() > 0 || this.hasRetryTaskInStandBy()) {
            WorkflowExecutionStatus executionStatus = this.runningState(state);
            log.info("The workflowInstance has task running, the workflowInstance status is {}", (Object)executionStatus);
            return executionStatus;
        }
        if (state == WorkflowExecutionStatus.READY_BLOCK) {
            WorkflowExecutionStatus executionStatus = this.processReadyBlock();
            log.info("The workflowInstance is ready to block, the workflowInstance status is {}", (Object)executionStatus);
            return executionStatus;
        }
        if (state == WorkflowExecutionStatus.READY_PAUSE) {
            WorkflowExecutionStatus executionStatus = this.processReadyPause();
            log.info("The workflowInstance is ready to pause, the workflow status is {}", (Object)executionStatus);
            return executionStatus;
        }
        if (state == WorkflowExecutionStatus.READY_STOP) {
            List<TaskInstance> killList = this.getCompleteTaskByState(TaskExecutionStatus.KILL);
            List<TaskInstance> failList = this.getCompleteTaskByState(TaskExecutionStatus.FAILURE);
            List<TaskInstance> stopList = this.getCompleteTaskByState(TaskExecutionStatus.STOP);
            WorkflowExecutionStatus executionStatus = CollectionUtils.isNotEmpty(stopList) || CollectionUtils.isNotEmpty(killList) || CollectionUtils.isNotEmpty(failList) || !this.isComplementEnd() ? WorkflowExecutionStatus.STOP : WorkflowExecutionStatus.SUCCESS;
            log.info("The workflowInstance is ready to stop, the workflow status is {}", (Object)executionStatus);
            return executionStatus;
        }
        if (this.processFailed()) {
            log.info("The workflowInstance is failed, the workflow status is {}", (Object)WorkflowExecutionStatus.FAILURE);
            return WorkflowExecutionStatus.FAILURE;
        }
        if (state == WorkflowExecutionStatus.RUNNING_EXECUTION) {
            List<TaskInstance> killTasks = this.getCompleteTaskByState(TaskExecutionStatus.KILL);
            if (this.readyToSubmitTaskQueue.size() > 0 || this.waitToRetryTaskInstanceMap.size() > 0) {
                return WorkflowExecutionStatus.RUNNING_EXECUTION;
            }
            if (CollectionUtils.isNotEmpty(killTasks)) {
                return WorkflowExecutionStatus.FAILURE;
            }
            return WorkflowExecutionStatus.SUCCESS;
        }
        return state;
    }

    private boolean isComplementEnd() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (!workflowInstance.isComplementData()) {
            return true;
        }
        Map cmdParam = JSONUtils.toMap((String)workflowInstance.getCommandParam());
        Date endTime = DateUtils.stringToDate((String)((String)cmdParam.get("complementEndDate")));
        return workflowInstance.getScheduleTime().equals(endTime);
    }

    private void updateProcessInstanceState() throws StateEventHandleException {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        WorkflowExecutionStatus state = this.getProcessInstanceState(workflowInstance);
        if (workflowInstance.getState() != state) {
            log.info("Update workflowInstance states, origin state: {}, target state: {}", (Object)workflowInstance.getState(), (Object)state);
            this.updateWorkflowInstanceStatesToDB(state);
            WorkflowStateEvent stateEvent = WorkflowStateEvent.builder().processInstanceId(workflowInstance.getId()).status(workflowInstance.getState()).type(StateEventType.PROCESS_STATE_CHANGE).build();
            this.stateEvents.add(stateEvent);
        } else {
            log.info("There is no need to update the workflow instance state, origin state: {}, target state: {}", (Object)workflowInstance.getState(), (Object)state);
        }
    }

    public void updateProcessInstanceState(WorkflowStateEvent stateEvent) throws StateEventHandleException {
        WorkflowExecutionStatus state = stateEvent.getStatus();
        this.updateWorkflowInstanceStatesToDB(state);
    }

    private void updateWorkflowInstanceStatesToDB(WorkflowExecutionStatus newStates) throws StateEventHandleException {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        WorkflowExecutionStatus originStates = workflowInstance.getState();
        if (originStates != newStates) {
            log.info("Begin to update workflow instance state , state will change from {} to {}", (Object)originStates, (Object)newStates);
            workflowInstance.setStateWithDesc(newStates, "update by workflow executor");
            if (newStates.isFinished()) {
                workflowInstance.setEndTime(new Date());
            }
            try {
                this.processInstanceDao.updateById((Object)workflowInstance);
            }
            catch (Exception ex) {
                workflowInstance.setStateWithDesc(originStates, "recover state by DB error");
                workflowInstance.setEndTime(null);
                throw new StateEventHandleException("Update process instance status to DB error", ex);
            }
        }
    }

    private DependResult getDependResultForTask(TaskInstance taskInstance) {
        return this.isTaskDepsComplete(taskInstance.getTaskCode());
    }

    public void addTaskToStandByList(TaskInstance taskInstance) {
        if (this.readyToSubmitTaskQueue.contains(taskInstance)) {
            log.warn("Task already exists in ready submit queue, no need to add again, task code:{}", (Object)taskInstance.getTaskCode());
            return;
        }
        log.info("Add task to stand by list, task name:{}, task id:{}, task code:{}", new Object[]{taskInstance.getName(), taskInstance.getId(), taskInstance.getTaskCode()});
        TaskMetrics.incTaskInstanceByState("submit");
        this.readyToSubmitTaskQueue.put(taskInstance);
    }

    private boolean removeTaskFromStandbyList(TaskInstance taskInstance) {
        return this.readyToSubmitTaskQueue.remove(taskInstance);
    }

    private boolean hasRetryTaskInStandBy() {
        Iterator iter = this.readyToSubmitTaskQueue.iterator();
        while (iter.hasNext()) {
            if (!((TaskInstance)iter.next()).getState().isFailure()) continue;
            return true;
        }
        return false;
    }

    public void killAllTasks() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        log.info("kill called on process instance id: {}, num: {}", (Object)workflowInstance.getId(), (Object)this.taskExecuteRunnableMap.size());
        if (this.readyToSubmitTaskQueue.size() > 0) {
            this.readyToSubmitTaskQueue.clear();
        }
        for (long taskCode : this.taskExecuteRunnableMap.keySet()) {
            Integer taskInstanceId = this.validTaskMap.get(taskCode);
            if (taskInstanceId == null || taskInstanceId.equals(0)) continue;
            LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)workflowInstance.getId(), (Integer)taskInstanceId);
            Throwable throwable = null;
            try {
                TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)taskInstanceId);
                if (taskInstance == null || taskInstance.getState().isFinished()) continue;
                DefaultTaskExecuteRunnable defaultTaskExecuteRunnable = this.taskExecuteRunnableMap.get(taskCode);
                defaultTaskExecuteRunnable.kill();
                if (!defaultTaskExecuteRunnable.getTaskInstance().getState().isFinished()) continue;
                TaskStateEvent taskStateEvent = TaskStateEvent.builder().processInstanceId(workflowInstance.getId()).taskInstanceId(taskInstance.getId()).status(defaultTaskExecuteRunnable.getTaskInstance().getState()).type(StateEventType.TASK_STATE_CHANGE).build();
                this.addStateEvent(taskStateEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mdcAutoClosableContext == null) continue;
                if (throwable != null) {
                    try {
                        mdcAutoClosableContext.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                mdcAutoClosableContext.close();
            }
        }
    }

    public boolean workFlowFinish() {
        return this.workflowExecuteContext.getWorkflowInstance().getState().isFinished();
    }

    public void submitStandByTask() throws StateEventHandleException {
        TaskInstance task;
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        while ((task = this.readyToSubmitTaskQueue.peek()) != null) {
            DependResult dependResult;
            TaskInstance retryTask;
            if (task.getId() != null && task.taskCanRetry() && (retryTask = (TaskInstance)this.taskInstanceDao.queryById((Serializable)task.getId())) != null && retryTask.getState().isForceSuccess()) {
                task.setState(retryTask.getState());
                log.info("Task {} has been forced success, put it into complete task list and stop retrying, taskInstanceId: {}", (Object)task.getName(), (Object)task.getId());
                this.removeTaskFromStandbyList(task);
                this.completeTaskSet.add(task.getTaskCode());
                this.taskInstanceMap.put(task.getId(), task);
                this.taskCodeInstanceMap.put(task.getTaskCode(), task);
                this.submitPostNode(task.getTaskCode());
                continue;
            }
            if (task.isFirstRun()) {
                String preTasks = this.workflowExecuteContext.getWorkflowGraph().getTaskNodeByCode(task.getTaskCode()).getPreTasks();
                HashSet<Long> preTaskList = new HashSet<Long>(JSONUtils.toList((String)preTasks, Long.class));
                this.getPreVarPool(task, preTaskList);
            }
            if (DependResult.SUCCESS == (dependResult = this.getDependResultForTask(task))) {
                log.info("The dependResult of task {} is success, so ready to submit to execute", (Object)task.getName());
                if (!this.executeTask(task)) {
                    this.taskFailedSubmit = true;
                    if (!this.removeTaskFromStandbyList(task)) {
                        log.error("Task submit failed, remove from standby list failed, workflowInstanceId: {}, taskCode: {}", (Object)workflowInstance.getId(), (Object)task.getTaskCode());
                    }
                    this.completeTaskSet.add(task.getTaskCode());
                    this.taskInstanceMap.put(task.getId(), task);
                    this.taskCodeInstanceMap.put(task.getTaskCode(), task);
                    this.errorTaskMap.put(task.getTaskCode(), task.getId());
                    this.taskExecuteRunnableMap.remove(task.getTaskCode());
                    log.error("Task submitted failed, workflowInstanceId: {}, taskInstanceId: {}, taskCode: {}", new Object[]{task.getProcessInstanceId(), task.getId(), task.getTaskCode()});
                    continue;
                }
                this.removeTaskFromStandbyList(task);
                continue;
            }
            if (DependResult.FAILED == dependResult) {
                this.dependFailedTaskSet.add(task.getTaskCode());
                this.removeTaskFromStandbyList(task);
                log.info("Task dependent result is failed, taskInstanceName: {} depend result : {}", (Object)task.getName(), (Object)dependResult);
                continue;
            }
            if (DependResult.NON_EXEC != dependResult) continue;
            this.removeTaskFromStandbyList(task);
            log.info("Remove task due to depend result not executed, taskInstanceName:{} depend result : {}", (Object)task.getName(), (Object)dependResult);
        }
    }

    protected List<TaskInstance> getRecoverTaskInstanceList(String cmdParam) {
        List startTaskInstanceIds;
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap != null && paramMap.containsKey("StartNodeIdList") && CollectionUtils.isNotEmpty(startTaskInstanceIds = Arrays.stream(((String)paramMap.get("StartNodeIdList")).split(",")).filter(StringUtils::isNotEmpty).map(Integer::valueOf).collect(Collectors.toList()))) {
            return this.taskInstanceDao.queryByIds(startTaskInstanceIds);
        }
        return Collections.emptyList();
    }

    private List<String> parseStartNodeName(String cmdParam) {
        List<String> startNodeNameList = new ArrayList<String>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap == null) {
            return startNodeNameList;
        }
        if (paramMap.containsKey("StartNodeList")) {
            startNodeNameList = Arrays.asList(((String)paramMap.get("StartNodeList")).split(","));
        }
        return startNodeNameList;
    }

    private List<String> getRecoveryNodeCodeList(List<TaskInstance> recoverNodeList) {
        ArrayList<String> recoveryNodeCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(recoverNodeList)) {
            for (TaskInstance task : recoverNodeList) {
                recoveryNodeCodeList.add(Long.toString(task.getTaskCode()));
            }
        }
        return recoveryNodeCodeList;
    }

    private boolean checkTaskQueue() {
        AtomicBoolean result = new AtomicBoolean(false);
        this.taskInstanceMap.forEach((id, taskInstance) -> {
            if (taskInstance != null && taskInstance.getTaskGroupId() > 0) {
                result.set(true);
            }
        });
        return result.get();
    }

    private boolean isNewProcessInstance() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (Flag.YES.equals((Object)workflowInstance.getRecovery())) {
            log.info("This workInstance will be recover by this execution");
            return false;
        }
        if (WorkflowExecutionStatus.RUNNING_EXECUTION == workflowInstance.getState() && workflowInstance.getRunTimes() == 1) {
            return true;
        }
        log.info("The workflowInstance has been executed before, this execution is to reRun, processInstance status: {}, runTimes: {}", (Object)workflowInstance.getState(), (Object)workflowInstance.getRunTimes());
        return false;
    }

    public Set<Long> getCompleteTaskCodes() {
        return this.completeTaskSet;
    }

    public Map<Long, DefaultTaskExecuteRunnable> getTaskExecuteRunnableMap() {
        return this.taskExecuteRunnableMap;
    }

    public Map<Long, TaskInstance> getWaitToRetryTaskInstanceMap() {
        return this.waitToRetryTaskInstanceMap;
    }

    private void setGlobalParamIfCommanded(ProcessDefinition processDefinition, Map<String, String> cmdParam) {
        Map startParamMap = new HashMap();
        if (cmdParam.containsKey("StartParams")) {
            String startParamJson = cmdParam.get("StartParams");
            startParamMap = JSONUtils.toMap((String)startParamJson);
        }
        Map fatherParamMap = new HashMap();
        if (cmdParam.containsKey("fatherParams")) {
            String fatherParamJson = cmdParam.get("fatherParams");
            fatherParamMap = JSONUtils.toMap((String)fatherParamJson);
        }
        startParamMap.putAll(fatherParamMap);
        Map globalMap = processDefinition.getGlobalParamMap();
        List globalParamList = processDefinition.getGlobalParamList();
        if (startParamMap.size() > 0 && globalMap != null) {
            for (Map.Entry entry : globalMap.entrySet()) {
                String val = (String)startParamMap.get(entry.getKey());
                if (val == null) continue;
                entry.setValue(val);
            }
            for (Map.Entry entry : startParamMap.entrySet()) {
                if (globalMap.containsKey(entry.getKey())) continue;
                globalMap.put(entry.getKey(), entry.getValue());
                globalParamList.add(new Property((String)entry.getKey(), Direct.IN, DataType.VARCHAR, (String)entry.getValue()));
            }
        }
    }

    protected void clearDataIfExecuteTask() {
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        if (!workflowInstance.getCommandType().equals((Object)CommandType.EXECUTE_TASK)) {
            return;
        }
        DAG<Long, TaskNode, TaskNodeRelation> dag = this.workflowExecuteContext.getWorkflowGraph().getDag();
        Set allNodesList = dag.getAllNodesList();
        ArrayList<TaskInstance> removeTaskInstances = new ArrayList<TaskInstance>();
        for (Long l : allNodesList) {
            TaskInstance taskInstance = this.validTaskMap.containsKey(l) ? this.taskInstanceMap.get(this.validTaskMap.get(l)) : this.taskInstanceDao.queryByWorkflowInstanceIdAndTaskCode(workflowInstance.getId(), l);
            if (taskInstance == null) continue;
            removeTaskInstances.add(taskInstance);
        }
        for (TaskInstance taskInstance : removeTaskInstances) {
            taskInstance.setFlag(Flag.NO);
            this.taskInstanceDao.updateById((Object)taskInstance);
        }
        HashSet removeSet = new HashSet();
        for (TaskInstance taskInstance : removeTaskInstances) {
            String taskVarPool = taskInstance.getVarPool();
            if (!StringUtils.isNotEmpty((CharSequence)taskVarPool)) continue;
            List properties = JSONUtils.toList((String)taskVarPool, Property.class);
            List keys = properties.stream().filter(property -> property.getDirect().equals((Object)Direct.OUT)).map(property -> String.format("%s_%s", property.getProp(), property.getType())).collect(Collectors.toList());
            removeSet.addAll(keys);
        }
        List list = JSONUtils.toList((String)workflowInstance.getVarPool(), Property.class);
        List list2 = list.stream().filter(property -> !property.getDirect().equals((Object)Direct.IN) || !removeSet.contains(String.format("%s_%s", property.getProp(), property.getType()))).collect(Collectors.toList());
        workflowInstance.setVarPool(JSONUtils.toJsonString(list2));
        this.processInstanceDao.updateById((Object)workflowInstance);
        this.completeTaskSet.removeIf(taskCode -> {
            Optional<TaskInstance> existTaskInstanceOptional = this.getTaskInstance((long)taskCode);
            return existTaskInstanceOptional.filter(taskInstance -> dag.containsNode((Object)taskInstance.getTaskCode())).isPresent();
        });
        this.taskInstanceMap.entrySet().removeIf(entry -> dag.containsNode((Object)((TaskInstance)entry.getValue()).getTaskCode()));
        this.validTaskMap.entrySet().removeIf(entry -> dag.containsNode(entry.getKey()));
        this.errorTaskMap.entrySet().removeIf(entry -> dag.containsNode(entry.getKey()));
    }

    private void saveCacheTaskInstance(TaskInstance taskInstance) {
        Pair taskIdAndCacheKey = TaskCacheUtils.revertCacheKey((String)taskInstance.getCacheKey());
        Integer taskId = (Integer)taskIdAndCacheKey.getLeft();
        if (taskId.equals(taskInstance.getId())) {
            taskInstance.setCacheKey((String)taskIdAndCacheKey.getRight());
            try {
                this.taskInstanceDao.updateById((Object)taskInstance);
            }
            catch (Exception e) {
                log.error("update task instance cache key failed", (Throwable)e);
            }
        }
    }

    private void sendTaskLogOnMasterToRemoteIfNeeded(TaskInstance taskInstance) {
        if (RemoteLogUtils.isRemoteLoggingEnable() && TaskUtils.isMasterTask(taskInstance.getTaskType())) {
            RemoteLogUtils.sendRemoteLog((String)taskInstance.getLogPath());
            log.info("Master sends task log {} to remote storage asynchronously.", (Object)taskInstance.getLogPath());
        }
    }

    private void mergeTaskInstanceVarPool(TaskInstance taskInstance) {
        String taskVarPoolJson = taskInstance.getVarPool();
        if (StringUtils.isEmpty((CharSequence)taskVarPoolJson)) {
            return;
        }
        ProcessInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        String processVarPoolJson = workflowInstance.getVarPool();
        if (StringUtils.isEmpty((CharSequence)processVarPoolJson)) {
            workflowInstance.setVarPool(taskVarPoolJson);
            return;
        }
        List<Object> processVarPool = new ArrayList(JSONUtils.toList((String)processVarPoolJson, Property.class));
        List taskVarPool = JSONUtils.toList((String)taskVarPoolJson, Property.class);
        Set newProcessVarPoolKeys = taskVarPool.stream().map(Property::getProp).collect(Collectors.toSet());
        processVarPool = processVarPool.stream().filter(property -> !newProcessVarPoolKeys.contains(property.getProp())).collect(Collectors.toList());
        processVarPool.addAll(taskVarPool);
        workflowInstance.setVarPool(JSONUtils.toJsonString(processVarPool));
    }

    private static enum WorkflowRunnableStatus {
        CREATED,
        INITIALIZE_QUEUE,
        STARTED;

    }
}

