/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.exception.WorkflowCreateException;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContextFactory;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnableFactory;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowExecuteRunnableFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecuteRunnableFactory.class);
    @Autowired
    private CommandService commandService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessInstanceDao processInstanceDao;
    @Autowired
    private MasterRpcClient masterRpcClient;
    @Autowired
    private ProcessAlertManager processAlertManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;
    @Autowired
    private CuringParamsService curingGlobalParamsService;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private DefaultTaskExecuteRunnableFactory defaultTaskExecuteRunnableFactory;
    @Autowired
    private WorkflowExecuteContextFactory workflowExecuteContextFactory;

    public Optional<WorkflowExecuteRunnable> createWorkflowExecuteRunnable(Command command) throws WorkflowCreateException {
        try {
            Optional<IWorkflowExecuteContext> workflowExecuteRunnableContextOptional = this.workflowExecuteContextFactory.createWorkflowExecuteRunnableContext(command);
            return workflowExecuteRunnableContextOptional.map(iWorkflowExecuteContext -> new WorkflowExecuteRunnable((IWorkflowExecuteContext)iWorkflowExecuteContext, this.commandService, this.processService, this.processInstanceDao, this.masterRpcClient, this.processAlertManager, this.masterConfig, this.stateWheelExecuteThread, this.curingGlobalParamsService, this.taskInstanceDao, this.defaultTaskExecuteRunnableFactory));
        }
        catch (Exception ex) {
            throw new WorkflowCreateException("Create workflow execute runnable failed", ex);
        }
    }
}

