/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.dispatcher;

import com.google.common.base.Preconditions;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.WorkerGroupNotFoundException;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.BaseTaskDispatcher;
import org.apache.dolphinscheduler.server.master.runner.execute.TaskExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkerTaskDispatcher
extends BaseTaskDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerTaskDispatcher.class);
    private final HostManager hostManager;

    public WorkerTaskDispatcher(TaskEventService taskEventService, MasterConfig masterConfig, MasterRpcClient masterRpcClient, HostManager hostManager) {
        super(taskEventService, masterConfig, masterRpcClient);
        this.hostManager = (HostManager)Preconditions.checkNotNull((Object)hostManager);
    }

    @Override
    protected Optional<Host> getTaskInstanceDispatchHost(TaskExecuteRunnable taskExecuteRunnable) throws WorkerGroupNotFoundException {
        String workerGroup = taskExecuteRunnable.getTaskExecutionContext().getWorkerGroup();
        return this.hostManager.select(workerGroup);
    }
}

