/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import java.util.concurrent.DelayQueue;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecutionContext;
import org.springframework.stereotype.Component;

@Component
public class AsyncMasterTaskDelayQueue {
    private final DelayQueue<AsyncTaskExecutionContext> asyncTaskCheckDelayQueue = new DelayQueue();

    public void addAsyncTask(@NonNull AsyncTaskExecutionContext asyncTaskExecutionContext) {
        if (asyncTaskExecutionContext == null) {
            throw new NullPointerException("asyncTaskExecutionContext is marked non-null but is null");
        }
        asyncTaskExecutionContext.refreshStartTime();
        this.asyncTaskCheckDelayQueue.add(asyncTaskExecutionContext);
    }

    @Nullable
    public AsyncTaskExecutionContext pollAsyncTask() throws InterruptedException {
        return (AsyncTaskExecutionContext)this.asyncTaskCheckDelayQueue.take();
    }

    public int getAsyncTaskRunningNum() {
        return this.asyncTaskCheckDelayQueue.size();
    }
}

