/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncMasterTaskDelayQueue;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskCallbackFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecuteFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecutionContext;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncMasterTaskDelayQueueLooper
extends BaseDaemonThread
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncMasterTaskDelayQueueLooper.class);
    @Autowired
    private AsyncMasterTaskDelayQueue asyncMasterTaskDelayQueue;
    @Autowired
    private MasterConfig masterConfig;
    private static final AtomicBoolean RUNNING_FLAG = new AtomicBoolean(false);
    private ExecutorService asyncTaskStateCheckThreadPool;

    public AsyncMasterTaskDelayQueueLooper() {
        super("AsyncMasterTaskDelayQueueLooper");
    }

    public synchronized void start() {
        if (!RUNNING_FLAG.compareAndSet(false, true)) {
            log.info("The AsyncMasterTaskDelayQueueLooper has already been started, will not start again");
            return;
        }
        log.info("AsyncMasterTaskDelayQueueLooper starting...");
        super.start();
        log.info("AsyncMasterTaskDelayQueueLooper started...");
    }

    public void run() {
        this.asyncTaskStateCheckThreadPool = ThreadUtils.newDaemonFixedThreadExecutor((String)"AsyncTaskStateCheckThreadPool", (int)this.masterConfig.getMasterAsyncTaskStateCheckThreadPoolSize());
        while (RUNNING_FLAG.get()) {
            AsyncTaskExecutionContext asyncTaskExecutionContext;
            try {
                asyncTaskExecutionContext = this.asyncMasterTaskDelayQueue.pollAsyncTask();
            }
            catch (InterruptedException e) {
                log.error("AsyncConditionTaskLooper has been interrupted, will break this loop", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
            TaskExecutionContext taskExecutionContext = asyncTaskExecutionContext.getTaskExecutionContext();
            LogUtils.MDCAutoClosableContext mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskExecutionContext.getProcessInstanceId(), (Integer)taskExecutionContext.getTaskInstanceId());
            Throwable throwable = null;
            try {
                LogUtils.MDCAutoClosableContext mdcAutoClosableContext1 = LogUtils.setTaskInstanceLogFullPathMDC((String)taskExecutionContext.getLogPath());
                Throwable throwable2 = null;
                try {
                    if (MasterTaskExecutionContextHolder.getTaskExecutionContext(taskExecutionContext.getTaskInstanceId()) == null) {
                        log.warn("Cannot find the taskInstance from TaskExecutionContextCacheManager, the task may already been killed, will stop the async master task");
                        continue;
                    }
                    this.asyncTaskStateCheckThreadPool.submit(() -> {
                        AsyncTaskExecuteFunction asyncTaskExecuteFunction = asyncTaskExecutionContext.getAsyncTaskExecuteFunction();
                        AsyncTaskCallbackFunction asyncTaskCallbackFunction = asyncTaskExecutionContext.getAsyncTaskCallbackFunction();
                        try {
                            LogUtils.setTaskInstanceLogFullPathMDC((String)taskExecutionContext.getLogPath());
                            LogUtils.setTaskInstanceIdMDC((Integer)taskExecutionContext.getTaskInstanceId());
                            AsyncTaskExecuteFunction.AsyncTaskExecutionStatus asyncTaskExecutionStatus = asyncTaskExecuteFunction.getAsyncTaskExecutionStatus();
                            switch (asyncTaskExecutionStatus) {
                                case RUNNING: {
                                    this.asyncMasterTaskDelayQueue.addAsyncTask(asyncTaskExecutionContext);
                                    return;
                                }
                                case SUCCESS: {
                                    asyncTaskCallbackFunction.executeSuccess();
                                    return;
                                }
                                case FAILED: {
                                    asyncTaskCallbackFunction.executeFailed();
                                    return;
                                }
                            }
                            return;
                        }
                        catch (Exception ex) {
                            asyncTaskCallbackFunction.executeThrowing(ex);
                            return;
                        }
                        finally {
                            LogUtils.removeTaskInstanceLogFullPathMDC();
                            LogUtils.removeTaskInstanceIdMDC();
                        }
                    });
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (mdcAutoClosableContext1 == null) continue;
                    if (throwable2 != null) {
                        try {
                            mdcAutoClosableContext1.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    mdcAutoClosableContext1.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (mdcAutoClosableContext == null) continue;
                if (throwable != null) {
                    try {
                        mdcAutoClosableContext.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                mdcAutoClosableContext.close();
            }
        }
        log.info("AsyncMasterTaskDelayQueueLooper closed...");
    }

    @Override
    public void close() throws Exception {
        if (!RUNNING_FLAG.compareAndSet(true, false)) {
            log.warn("The AsyncMasterTaskDelayQueueLooper is not started, will not close");
            return;
        }
        log.info("AsyncMasterTaskDelayQueueLooper closing...");
        this.asyncTaskStateCheckThreadPool.shutdown();
        log.info("AsyncMasterTaskDelayQueueLooper closed...");
    }
}

