/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskInstanceLogHeader;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncMasterDelayTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskCallbackFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTaskCallbackFunctionImpl
implements AsyncTaskCallbackFunction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskCallbackFunctionImpl.class);
    private final AsyncMasterDelayTaskExecuteRunnable asyncMasterDelayTaskExecuteRunnable;

    public AsyncTaskCallbackFunctionImpl(@NonNull AsyncMasterDelayTaskExecuteRunnable asyncMasterDelayTaskExecuteRunnable) {
        if (asyncMasterDelayTaskExecuteRunnable == null) {
            throw new NullPointerException("asyncMasterDelayTaskExecuteRunnable is marked non-null but is null");
        }
        this.asyncMasterDelayTaskExecuteRunnable = asyncMasterDelayTaskExecuteRunnable;
    }

    @Override
    public void executeSuccess() {
        this.asyncMasterDelayTaskExecuteRunnable.getTaskExecutionContext().setCurrentExecutionStatus(TaskExecutionStatus.SUCCESS);
        this.executeFinished();
    }

    @Override
    public void executeFailed() {
        this.asyncMasterDelayTaskExecuteRunnable.getTaskExecutionContext().setCurrentExecutionStatus(TaskExecutionStatus.FAILURE);
        this.executeFinished();
    }

    @Override
    public void executeThrowing(Throwable throwable) {
        this.asyncMasterDelayTaskExecuteRunnable.afterThrowing(throwable);
    }

    private void executeFinished() {
        TaskInstanceLogHeader.printFinalizeTaskHeader();
        int taskInstanceId = this.asyncMasterDelayTaskExecuteRunnable.getTaskExecutionContext().getTaskInstanceId();
        MasterTaskExecutionContextHolder.removeTaskExecutionContext(taskInstanceId);
        MasterTaskExecuteRunnableHolder.removeMasterTaskExecuteRunnable(taskInstanceId);
        log.info("Task execute finished, removed the TaskExecutionContext");
        this.asyncMasterDelayTaskExecuteRunnable.sendTaskResult();
        log.info("Execute task finished, will send the task execute result to master, the current task execute result is {}", (Object)this.asyncMasterDelayTaskExecuteRunnable.getTaskExecutionContext().getCurrentExecutionStatus().name());
        this.asyncMasterDelayTaskExecuteRunnable.closeLogAppender();
    }
}

