/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskCallbackFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecuteFunction;

public class AsyncTaskExecutionContext
implements Delayed {
    private final TaskExecutionContext taskExecutionContext;
    private final AsyncTaskExecuteFunction asyncTaskExecuteFunction;
    private final AsyncTaskCallbackFunction asyncTaskCallbackFunction;
    private long currentStartTime;
    private int executeTimes;
    private final long executeInterval;
    private long timeout;

    public AsyncTaskExecutionContext(@NonNull TaskExecutionContext taskExecutionContext, @NonNull AsyncTaskExecuteFunction asyncTaskExecuteFunction, @NonNull AsyncTaskCallbackFunction asyncTaskCallbackFunction) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (asyncTaskExecuteFunction == null) {
            throw new NullPointerException("asyncTaskExecuteFunction is marked non-null but is null");
        }
        if (asyncTaskCallbackFunction == null) {
            throw new NullPointerException("asyncTaskCallbackFunction is marked non-null but is null");
        }
        this.taskExecutionContext = taskExecutionContext;
        this.asyncTaskExecuteFunction = asyncTaskExecuteFunction;
        this.asyncTaskCallbackFunction = asyncTaskCallbackFunction;
        this.currentStartTime = 0L;
        this.executeTimes = 0;
        this.timeout = TaskTimeoutStrategy.FAILED.equals((Object)taskExecutionContext.getTaskTimeoutStrategy()) || TaskTimeoutStrategy.WARNFAILED.equals((Object)taskExecutionContext.getTaskTimeoutStrategy()) ? taskExecutionContext.getStartTime() + TimeUnit.SECONDS.toMillis(taskExecutionContext.getTaskTimeout()) : TimeUnit.SECONDS.toMillis(Integer.MAX_VALUE);
        this.executeInterval = Math.max(asyncTaskExecuteFunction.getAsyncTaskStateCheckInterval().toMillis(), 1000L);
    }

    public void refreshStartTime() {
        if (this.executeTimes == 0) {
            ++this.executeTimes;
        } else {
            this.currentStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long nextExecuteTimeDelay = Math.min(this.currentStartTime + this.executeInterval, this.timeout) - System.currentTimeMillis();
        return unit.convert(nextExecuteTimeDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        return Long.compare(this.getDelay(TimeUnit.SECONDS), o.getDelay(TimeUnit.SECONDS));
    }

    @Generated
    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    @Generated
    public AsyncTaskExecuteFunction getAsyncTaskExecuteFunction() {
        return this.asyncTaskExecuteFunction;
    }

    @Generated
    public AsyncTaskCallbackFunction getAsyncTaskCallbackFunction() {
        return this.asyncTaskCallbackFunction;
    }

    @Generated
    public long getCurrentStartTime() {
        return this.currentStartTime;
    }

    @Generated
    public int getExecuteTimes() {
        return this.executeTimes;
    }

    @Generated
    public long getExecuteInterval() {
        return this.executeInterval;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setCurrentStartTime(long currentStartTime) {
        this.currentStartTime = currentStartTime;
    }

    @Generated
    public void setExecuteTimes(int executeTimes) {
        this.executeTimes = executeTimes;
    }

    @Generated
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncTaskExecutionContext)) {
            return false;
        }
        AsyncTaskExecutionContext other = (AsyncTaskExecutionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentStartTime() != other.getCurrentStartTime()) {
            return false;
        }
        if (this.getExecuteTimes() != other.getExecuteTimes()) {
            return false;
        }
        if (this.getExecuteInterval() != other.getExecuteInterval()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        TaskExecutionContext this$taskExecutionContext = this.getTaskExecutionContext();
        TaskExecutionContext other$taskExecutionContext = other.getTaskExecutionContext();
        if (this$taskExecutionContext == null ? other$taskExecutionContext != null : !this$taskExecutionContext.equals(other$taskExecutionContext)) {
            return false;
        }
        AsyncTaskExecuteFunction this$asyncTaskExecuteFunction = this.getAsyncTaskExecuteFunction();
        AsyncTaskExecuteFunction other$asyncTaskExecuteFunction = other.getAsyncTaskExecuteFunction();
        if (this$asyncTaskExecuteFunction == null ? other$asyncTaskExecuteFunction != null : !this$asyncTaskExecuteFunction.equals(other$asyncTaskExecuteFunction)) {
            return false;
        }
        AsyncTaskCallbackFunction this$asyncTaskCallbackFunction = this.getAsyncTaskCallbackFunction();
        AsyncTaskCallbackFunction other$asyncTaskCallbackFunction = other.getAsyncTaskCallbackFunction();
        return !(this$asyncTaskCallbackFunction == null ? other$asyncTaskCallbackFunction != null : !this$asyncTaskCallbackFunction.equals(other$asyncTaskCallbackFunction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncTaskExecutionContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $currentStartTime = this.getCurrentStartTime();
        result = result * 59 + (int)($currentStartTime >>> 32 ^ $currentStartTime);
        result = result * 59 + this.getExecuteTimes();
        long $executeInterval = this.getExecuteInterval();
        result = result * 59 + (int)($executeInterval >>> 32 ^ $executeInterval);
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        TaskExecutionContext $taskExecutionContext = this.getTaskExecutionContext();
        result = result * 59 + ($taskExecutionContext == null ? 43 : $taskExecutionContext.hashCode());
        AsyncTaskExecuteFunction $asyncTaskExecuteFunction = this.getAsyncTaskExecuteFunction();
        result = result * 59 + ($asyncTaskExecuteFunction == null ? 43 : $asyncTaskExecuteFunction.hashCode());
        AsyncTaskCallbackFunction $asyncTaskCallbackFunction = this.getAsyncTaskCallbackFunction();
        result = result * 59 + ($asyncTaskCallbackFunction == null ? 43 : $asyncTaskCallbackFunction.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AsyncTaskExecutionContext(taskExecutionContext=" + this.getTaskExecutionContext() + ", asyncTaskExecuteFunction=" + this.getAsyncTaskExecuteFunction() + ", asyncTaskCallbackFunction=" + this.getAsyncTaskCallbackFunction() + ", currentStartTime=" + this.getCurrentStartTime() + ", executeTimes=" + this.getExecuteTimes() + ", executeInterval=" + this.getExecuteInterval() + ", timeout=" + this.getTimeout() + ")";
    }
}

