/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.exception.TaskExecuteRunnableCreateException;
import org.apache.dolphinscheduler.server.master.exception.TaskExecutionContextCreateException;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.TaskExecuteRunnableFactory;
import org.apache.dolphinscheduler.server.master.runner.execute.TaskExecutionContextFactory;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskOperatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTaskExecuteRunnableFactory
implements TaskExecuteRunnableFactory<DefaultTaskExecuteRunnable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskExecuteRunnableFactory.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private TaskExecutionContextFactory taskExecutionContextFactory;
    @Autowired
    private TaskOperatorManager taskOperatorManager;

    @Override
    public DefaultTaskExecuteRunnable createTaskExecuteRunnable(TaskInstance taskInstance) throws TaskExecuteRunnableCreateException {
        WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(taskInstance.getProcessInstanceId());
        try {
            return new DefaultTaskExecuteRunnable(workflowExecuteRunnable.getWorkflowExecuteContext().getWorkflowInstance(), taskInstance, this.taskExecutionContextFactory.createTaskExecutionContext(taskInstance), this.taskOperatorManager);
        }
        catch (TaskExecutionContextCreateException ex) {
            throw new TaskExecuteRunnableCreateException("Create DefaultTaskExecuteRunnable failed", ex);
        }
    }
}

