/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.message.MasterMessageSenderManager;
import org.apache.dolphinscheduler.server.master.runner.task.LogicTaskPluginFactoryBuilder;

public abstract class MasterDelayTaskExecuteRunnable
extends MasterTaskExecuteRunnable
implements Delayed {
    public MasterDelayTaskExecuteRunnable(TaskExecutionContext taskExecutionContext, LogicTaskPluginFactoryBuilder logicTaskPluginFactoryBuilder, MasterMessageSenderManager masterMessageSenderManager) {
        super(taskExecutionContext, logicTaskPluginFactoryBuilder, masterMessageSenderManager);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MasterDelayTaskExecuteRunnable)) {
            return false;
        }
        MasterDelayTaskExecuteRunnable other = (MasterDelayTaskExecuteRunnable)obj;
        return other.getTaskExecutionContext().getTaskInstanceId() == this.getTaskExecutionContext().getTaskInstanceId();
    }

    public int hashCode() {
        return this.getTaskExecutionContext().getTaskInstanceId();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        TaskExecutionContext taskExecutionContext = this.getTaskExecutionContext();
        return unit.convert(DateUtils.getRemainTime((Long)taskExecutionContext.getFirstSubmitTime(), (long)((long)taskExecutionContext.getDelayTime() * 60L)), TimeUnit.SECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }
}

