/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import ch.qos.logback.classic.ClassicConstants;
import lombok.Generated;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskInstanceLogHeader;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskFactoryNotFoundException;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskInitializeException;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.apache.dolphinscheduler.server.master.runner.message.MasterMessageSenderManager;
import org.apache.dolphinscheduler.server.master.runner.task.ILogicTask;
import org.apache.dolphinscheduler.server.master.runner.task.LogicTaskPluginFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MasterTaskExecuteRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterTaskExecuteRunnable.class);
    protected final TaskExecutionContext taskExecutionContext;
    protected final LogicTaskPluginFactoryBuilder logicTaskPluginFactoryBuilder;
    protected final MasterMessageSenderManager masterMessageSenderManager;
    protected ILogicTask logicTask;

    public MasterTaskExecuteRunnable(TaskExecutionContext taskExecutionContext, LogicTaskPluginFactoryBuilder logicTaskPluginFactoryBuilder, MasterMessageSenderManager masterMessageSenderManager) {
        this.taskExecutionContext = taskExecutionContext;
        this.logicTaskPluginFactoryBuilder = logicTaskPluginFactoryBuilder;
        this.masterMessageSenderManager = masterMessageSenderManager;
    }

    protected abstract void executeTask() throws MasterTaskExecuteException;

    protected abstract void afterExecute() throws MasterTaskExecuteException;

    protected void afterThrowing(Throwable throwable) {
        TaskInstanceLogHeader.printFinalizeTaskHeader();
        try {
            log.error("Get a exception when execute the task, will try to cancel the task", throwable);
            this.cancelTask();
        }
        catch (Exception e) {
            log.error("Cancel task failed,", (Throwable)e);
        }
        this.taskExecutionContext.setCurrentExecutionStatus(TaskExecutionStatus.FAILURE);
        this.sendTaskResult();
        log.info("Get a exception when execute the task, sent the task execute result to master, the current task execute result is {}", (Object)this.taskExecutionContext.getCurrentExecutionStatus());
        MasterTaskExecutionContextHolder.removeTaskExecutionContext(this.taskExecutionContext.getTaskInstanceId());
        MasterTaskExecuteRunnableHolder.removeMasterTaskExecuteRunnable(this.taskExecutionContext.getTaskInstanceId());
        log.info("Get a exception when execute the task, removed the TaskExecutionContext");
        this.closeLogAppender();
    }

    public void cancelTask() throws MasterTaskExecuteException {
        if (this.logicTask != null) {
            this.logicTask.kill();
        }
    }

    public void pauseTask() throws MasterTaskExecuteException {
        if (this.logicTask != null) {
            this.logicTask.pause();
        }
    }

    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    public ILogicTask getILogicTask() {
        return this.logicTask;
    }

    @Override
    public void run() {
        try {
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)this.taskExecutionContext.getProcessInstanceId(), (Integer)this.taskExecutionContext.getTaskInstanceId());
            LogUtils.setTaskInstanceLogFullPathMDC((String)this.taskExecutionContext.getLogPath());
            TaskInstanceLogHeader.printInitializeTaskContextHeader();
            this.initializeTask();
            TaskInstanceLogHeader.printLoadTaskInstancePluginHeader();
            this.beforeExecute();
            TaskInstanceLogHeader.printExecuteTaskHeader();
            this.executeTask();
            this.afterExecute();
        }
        catch (Throwable ex) {
            log.error("Task execute failed, due to meet an exception", ex);
            this.afterThrowing(ex);
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
            LogUtils.removeTaskInstanceLogFullPathMDC();
        }
    }

    protected void initializeTask() {
        log.info("Begin to initialize task");
        long taskStartTime = System.currentTimeMillis();
        this.taskExecutionContext.setStartTime(taskStartTime);
        log.info("Set task startTime: {}", (Object)taskStartTime);
        String taskAppId = String.format("%s_%s", this.taskExecutionContext.getProcessInstanceId(), this.taskExecutionContext.getTaskInstanceId());
        this.taskExecutionContext.setTaskAppId(taskAppId);
        log.info("Set task appId: {}", (Object)taskAppId);
        log.info("End initialize task {}", (Object)JSONUtils.toPrettyJsonString((Object)this.taskExecutionContext));
    }

    protected void beforeExecute() throws LogicTaskFactoryNotFoundException, LogicTaskInitializeException, RemotingException {
        this.taskExecutionContext.setCurrentExecutionStatus(TaskExecutionStatus.RUNNING_EXECUTION);
        this.masterMessageSenderManager.getMasterTaskExecuteRunningMessageSender().sendMessage(this.taskExecutionContext);
        log.info("Send task status {} to master {}", (Object)this.taskExecutionContext.getCurrentExecutionStatus().name(), (Object)this.taskExecutionContext.getWorkflowInstanceHost());
        this.logicTask = this.logicTaskPluginFactoryBuilder.createILogicTaskPluginFactory(this.taskExecutionContext.getTaskType()).createLogicTask(this.taskExecutionContext);
        log.info("Initialized task plugin instance: {} successfully", (Object)this.taskExecutionContext.getTaskType());
        this.logicTask.getTaskParameters().setVarPool(this.taskExecutionContext.getVarPool());
        log.info("Initialize taskVarPool: {} successfully", (Object)this.taskExecutionContext.getVarPool());
    }

    protected void closeLogAppender() {
        try {
            if (RemoteLogUtils.isRemoteLoggingEnable()) {
                RemoteLogUtils.sendRemoteLog((String)this.taskExecutionContext.getLogPath());
                log.info("Send task log {} to remote storage successfully", (Object)this.taskExecutionContext.getLogPath());
            }
        }
        catch (Exception ex) {
            log.error("Send task log {} to remote storage failed", (Object)this.taskExecutionContext.getLogPath(), (Object)ex);
        }
        finally {
            log.info(ClassicConstants.FINALIZE_SESSION_MARKER, ClassicConstants.FINALIZE_SESSION_MARKER.toString());
        }
    }

    protected void sendTaskResult() {
        try {
            this.taskExecutionContext.setEndTime(System.currentTimeMillis());
            this.taskExecutionContext.setVarPool(JSONUtils.toJsonString((Object)this.logicTask.getTaskParameters().getVarPool()));
            this.masterMessageSenderManager.getMasterTaskExecuteResultMessageSender().sendMessage(this.taskExecutionContext);
            log.info("Send task status: {} to master: {} successfully", (Object)this.taskExecutionContext.getCurrentExecutionStatus().name(), (Object)this.taskExecutionContext.getWorkflowInstanceHost());
        }
        catch (Exception ex) {
            log.error("Send task status: {} to master: {} failed", new Object[]{this.taskExecutionContext.getCurrentExecutionStatus().name(), this.taskExecutionContext.getWorkflowInstanceHost(), ex});
        }
    }
}

