/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncMasterDelayTaskExecuteRunnableFactory;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterDelayTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterDelayTaskExecuteRunnableFactory;
import org.apache.dolphinscheduler.server.master.runner.execute.SyncMasterDelayTaskExecuteRunnableFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskExecuteRunnableFactoryBuilder {
    @Autowired
    private AsyncMasterDelayTaskExecuteRunnableFactory asyncMasterDelayTaskExecuteRunnableFactory;
    @Autowired
    private SyncMasterDelayTaskExecuteRunnableFactory syncMasterDelayTaskExecuteRunnableFactory;
    private static final Set<String> ASYNC_TASK_TYPE = Sets.newHashSet((Object[])new String[]{"DEPENDENT", "SUB_PROCESS", "DYNAMIC"});

    public MasterDelayTaskExecuteRunnableFactory<? extends MasterDelayTaskExecuteRunnable> createWorkerDelayTaskExecuteRunnableFactory(String taskType) {
        if (ASYNC_TASK_TYPE.contains(taskType)) {
            return this.asyncMasterDelayTaskExecuteRunnableFactory;
        }
        return this.syncMasterDelayTaskExecuteRunnableFactory;
    }
}

