/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterTaskExecutionContextHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterTaskExecutionContextHolder.class);
    private static final Map<Integer, TaskExecutionContext> TASK_EXECUTION_CONTEXT_MAP = new ConcurrentHashMap<Integer, TaskExecutionContext>();

    public static void putTaskExecutionContext(TaskExecutionContext taskExecutionContext) {
        if (TASK_EXECUTION_CONTEXT_MAP.containsKey(taskExecutionContext.getTaskInstanceId())) {
            log.error("The TaskExecutionContext {} already exists in the MasterTaskExecutionContextHolder", (Object)taskExecutionContext);
        }
        TASK_EXECUTION_CONTEXT_MAP.put(taskExecutionContext.getTaskInstanceId(), taskExecutionContext);
    }

    public static TaskExecutionContext getTaskExecutionContext(int taskInstanceId) {
        return TASK_EXECUTION_CONTEXT_MAP.get(taskInstanceId);
    }

    public static void removeTaskExecutionContext(int taskInstanceId) {
        TASK_EXECUTION_CONTEXT_MAP.remove(taskInstanceId);
    }
}

