/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import com.google.common.base.Preconditions;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.runner.execute.TaskExecuteRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class PriorityTaskExecuteRunnable
implements TaskExecuteRunnable,
Comparable<TaskExecuteRunnable> {
    private final ProcessInstance workflowInstance;
    private final TaskInstance taskInstance;
    private final TaskExecutionContext taskExecutionContext;

    public PriorityTaskExecuteRunnable(ProcessInstance workflowInstance, TaskInstance taskInstance, TaskExecutionContext taskExecutionContext) {
        this.taskInstance = (TaskInstance)Preconditions.checkNotNull((Object)taskInstance);
        this.workflowInstance = (ProcessInstance)Preconditions.checkNotNull((Object)workflowInstance);
        this.taskExecutionContext = (TaskExecutionContext)Preconditions.checkNotNull((Object)taskExecutionContext);
    }

    @Override
    public ProcessInstance getWorkflowInstance() {
        return this.workflowInstance;
    }

    @Override
    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    @Override
    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    @Override
    public int compareTo(@NotNull TaskExecuteRunnable other) {
        int dispatchFailTimesCompareResult = this.taskExecutionContext.getDispatchFailTimes() - other.getTaskExecutionContext().getDispatchFailTimes();
        if (dispatchFailTimesCompareResult != 0) {
            return dispatchFailTimesCompareResult;
        }
        int workflowInstancePriorityCompareResult = this.workflowInstance.getProcessInstancePriority().getCode() - other.getWorkflowInstance().getProcessInstancePriority().getCode();
        if (workflowInstancePriorityCompareResult != 0) {
            return workflowInstancePriorityCompareResult;
        }
        int workflowInstanceIdCompareResult = this.workflowInstance.getId() - other.getWorkflowInstance().getId();
        if (workflowInstanceIdCompareResult != 0) {
            return workflowInstanceIdCompareResult;
        }
        int taskInstancePriorityCompareResult = this.taskInstance.getTaskInstancePriority().getCode() - other.getTaskInstance().getTaskInstancePriority().getCode();
        if (taskInstancePriorityCompareResult != 0) {
            return taskInstancePriorityCompareResult;
        }
        int taskGroupPriorityCompareResult = this.taskInstance.getTaskGroupPriority() - other.getTaskInstance().getTaskGroupPriority();
        if (taskGroupPriorityCompareResult != 0) {
            return -taskGroupPriorityCompareResult;
        }
        return this.taskInstance.getId() - other.getTaskInstance().getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PriorityTaskExecuteRunnable) {
            PriorityTaskExecuteRunnable other = (PriorityTaskExecuteRunnable)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.taskInstance.getId();
    }
}

