/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskInstanceLogHeader;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterDelayTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecuteRunnableHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.apache.dolphinscheduler.server.master.runner.message.MasterMessageSenderManager;
import org.apache.dolphinscheduler.server.master.runner.task.ISyncLogicTask;
import org.apache.dolphinscheduler.server.master.runner.task.LogicTaskPluginFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMasterDelayTaskExecuteRunnable
extends MasterDelayTaskExecuteRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncMasterDelayTaskExecuteRunnable.class);

    public SyncMasterDelayTaskExecuteRunnable(TaskExecutionContext taskExecutionContext, LogicTaskPluginFactoryBuilder logicTaskPluginFactoryBuilder, MasterMessageSenderManager masterMessageSenderManager) {
        super(taskExecutionContext, logicTaskPluginFactoryBuilder, masterMessageSenderManager);
    }

    @Override
    protected void executeTask() throws MasterTaskExecuteException {
        if (this.logicTask == null) {
            throw new MasterTaskExecuteException("The task plugin instance is null");
        }
        ISyncLogicTask iSyncLogicTask = (ISyncLogicTask)this.logicTask;
        iSyncLogicTask.handle();
    }

    @Override
    protected void afterExecute() throws MasterTaskExecuteException {
        TaskInstanceLogHeader.printFinalizeTaskHeader();
        if (this.logicTask == null) {
            throw new MasterTaskExecuteException("The current task instance is null");
        }
        this.sendTaskResult();
        log.info("Execute task finished, will send the task execute result to master, the current task execute result is {}", (Object)this.taskExecutionContext.getCurrentExecutionStatus().name());
        this.closeLogAppender();
        MasterTaskExecutionContextHolder.removeTaskExecutionContext(this.taskExecutionContext.getTaskInstanceId());
        MasterTaskExecuteRunnableHolder.removeMasterTaskExecuteRunnable(this.taskExecutionContext.getTaskInstanceId());
    }
}

