/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.message;

import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskExecuteRunningMessage;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.message.MasterMessageSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskExecuteRunningMessageSender
implements MasterMessageSender<TaskExecuteRunningMessage> {
    @Autowired
    private MasterRpcClient masterRpcClient;
    @Autowired
    private MasterConfig masterConfig;

    @Override
    public void sendMessage(TaskExecuteRunningMessage message) throws RemotingException {
        this.masterRpcClient.send(Host.of((String)message.getMessageReceiverAddress()), message.convert2Command());
    }

    @Override
    public TaskExecuteRunningMessage buildMessage(@NonNull TaskExecutionContext taskExecutionContext) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        TaskExecuteRunningMessage taskExecuteRunningMessage = new TaskExecuteRunningMessage(this.masterConfig.getMasterAddress(), taskExecutionContext.getWorkflowInstanceHost(), System.currentTimeMillis());
        taskExecuteRunningMessage.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskExecuteRunningMessage.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskExecuteRunningMessage.setStatus(taskExecutionContext.getCurrentExecutionStatus());
        taskExecuteRunningMessage.setLogPath(taskExecutionContext.getLogPath());
        taskExecuteRunningMessage.setHost(taskExecutionContext.getHost());
        taskExecuteRunningMessage.setStartTime(taskExecutionContext.getStartTime());
        taskExecuteRunningMessage.setExecutePath(taskExecutionContext.getExecutePath());
        taskExecuteRunningMessage.setAppIds(taskExecutionContext.getAppIds());
        return taskExecuteRunningMessage;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.TASK_EXECUTE_RUNNING_MESSAGE;
    }
}

