/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.message;

import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.task.TaskUpdateRuntimeMessage;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.message.MasterMessageSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskUpdateRuntimeMessageSender
implements MasterMessageSender<TaskUpdateRuntimeMessage> {
    @Autowired
    private MasterRpcClient masterRpcClient;
    @Autowired
    private MasterConfig masterConfig;

    @Override
    public void sendMessage(TaskUpdateRuntimeMessage message) throws RemotingException {
        this.masterRpcClient.send(Host.of((String)message.getMessageReceiverAddress()), message.convert2Command());
    }

    @Override
    public TaskUpdateRuntimeMessage buildMessage(@NonNull TaskExecutionContext taskExecutionContext) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        TaskUpdateRuntimeMessage taskUpdatePidRequest = new TaskUpdateRuntimeMessage(this.masterConfig.getMasterAddress(), taskExecutionContext.getWorkflowInstanceHost(), System.currentTimeMillis());
        taskUpdatePidRequest.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskUpdatePidRequest.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskUpdatePidRequest.setHost(taskExecutionContext.getHost());
        taskUpdatePidRequest.setStartTime(taskExecutionContext.getStartTime());
        return taskUpdatePidRequest;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.TASK_UPDATE_RUNTIME_MESSAGE;
    }
}

