/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.remote.command.task.TaskKillRequest;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskKillOperator
implements TaskOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskKillOperator.class);
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private MasterRpcClient masterRpcClient;

    @Override
    public void handle(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        TaskInstance taskInstance = taskExecuteRunnable.getTaskInstance();
        log.info("Begin to kill task instance: {}", (Object)taskInstance.getName());
        if (taskInstance.getState().isFinished()) {
            log.info("The task stance {} is finished, no need to kill", (Object)taskInstance.getName());
            return;
        }
        try {
            this.killTaskInstanceInDB(taskInstance);
            this.killRemoteTaskInstanceInThreadPool(taskInstance);
        }
        catch (Exception ex) {
            log.error("Kill task instance {} failed", (Object)taskInstance.getName(), (Object)ex);
        }
    }

    private void killTaskInstanceInDB(TaskInstance taskInstance) {
        taskInstance.setState(TaskExecutionStatus.KILL);
        taskInstance.setEndTime(new Date());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    private void killRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) throws RemotingException {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            return;
        }
        TaskKillRequest killCommand = new TaskKillRequest(taskInstance.getId().intValue());
        this.masterRpcClient.send(Host.of((String)taskInstance.getHost()), killCommand.convert2Command());
    }
}

