/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.task.TaskPauseRequest;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskPauseOperator
implements TaskOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskPauseOperator.class);
    @Autowired
    private MasterRpcClient masterRpcClient;

    @Override
    public void handle(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        try {
            this.pauseRemoteTaskInstanceInThreadPool(taskExecuteRunnable.getTaskInstance());
        }
        catch (Exception e) {
            log.error("Pause MasterTaskExecuteRunnable failed", (Throwable)e);
        }
    }

    private void pauseRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) throws RemotingException {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            log.info("The task instance: {}'s host is null", (Object)taskInstance.getName());
            return;
        }
        this.masterRpcClient.send(Host.of((String)taskInstance.getHost()), new TaskPauseRequest(taskInstance.getId()).convert2Command());
    }
}

