/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.remote.command.task.TaskKillRequest;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcClient;
import org.apache.dolphinscheduler.server.master.runner.execute.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskTimeoutOperator
implements TaskOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskTimeoutOperator.class);
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private MasterRpcClient masterRpcClient;

    @Override
    public void handle(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        TaskInstance taskInstance = taskExecuteRunnable.getTaskInstance();
        TaskTimeoutStrategy taskTimeoutStrategy = taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy) {
            log.warn("TaskInstance: {} timeout, the current timeout strategy is {}, will continue running", (Object)taskInstance.getName(), (Object)taskTimeoutStrategy.name());
            return;
        }
        try {
            this.timeoutTaskInstanceInDB(taskInstance);
            this.killRemoteTaskInstanceInThreadPool(taskInstance);
            log.info("TaskInstance: {} timeout, killed the task instance", (Object)taskInstance.getName());
        }
        catch (Exception ex) {
            log.error("TaskInstance timeout {} failed", (Object)taskInstance.getName(), (Object)ex);
        }
    }

    private void timeoutTaskInstanceInDB(TaskInstance taskInstance) {
        taskInstance.setState(TaskExecutionStatus.FAILURE);
        taskInstance.setEndTime(new Date());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    private void killRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) throws RemotingException {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            return;
        }
        TaskKillRequest killCommand = new TaskKillRequest(taskInstance.getId().intValue());
        this.masterRpcClient.send(Host.of((String)taskInstance.getHost()), killCommand.convert2Command());
    }
}

