/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.apache.dolphinscheduler.server.master.runner.task.IAsyncLogicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAsyncLogicTask<T extends AbstractParameters>
implements IAsyncLogicTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAsyncLogicTask.class);
    protected final TaskExecutionContext taskExecutionContext;
    protected final T taskParameters;

    protected BaseAsyncLogicTask(TaskExecutionContext taskExecutionContext, T taskParameters) {
        this.taskExecutionContext = taskExecutionContext;
        this.taskParameters = taskParameters;
        log.info("Success initialize task parameters: \n{}", (Object)JSONUtils.toPrettyJsonString(taskParameters));
    }

    @Override
    public void kill() {
        MasterTaskExecutionContextHolder.removeTaskExecutionContext(this.taskExecutionContext.getTaskInstanceId());
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        MasterTaskExecutionContextHolder.removeTaskExecutionContext(this.taskExecutionContext.getTaskInstanceId());
    }

    @Override
    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    @Override
    public AbstractParameters getTaskParameters() {
        return this.taskParameters;
    }
}

