/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskFactoryNotFoundException;
import org.apache.dolphinscheduler.server.master.runner.task.ILogicTaskPluginFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicTaskPluginFactoryBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskPluginFactoryBuilder.class);
    private final Map<String, ILogicTaskPluginFactory> logicTaskPluginFactoryMap = new ConcurrentHashMap<String, ILogicTaskPluginFactory>();

    public LogicTaskPluginFactoryBuilder(List<ILogicTaskPluginFactory> logicTaskPluginFactories) {
        logicTaskPluginFactories.forEach(logicTaskPluginFactory -> this.logicTaskPluginFactoryMap.put(logicTaskPluginFactory.getTaskType(), (ILogicTaskPluginFactory)logicTaskPluginFactory));
    }

    public ILogicTaskPluginFactory createILogicTaskPluginFactory(String taskType) throws LogicTaskFactoryNotFoundException {
        ILogicTaskPluginFactory logicTaskPluginFactory = this.logicTaskPluginFactoryMap.get(taskType);
        if (logicTaskPluginFactory == null) {
            throw new LogicTaskFactoryNotFoundException("Cannot find the logic task factory: " + taskType);
        }
        return logicTaskPluginFactory;
    }
}

