/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.dependent;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecuteFunction;
import org.apache.dolphinscheduler.server.master.utils.DependentExecute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentAsyncTaskExecuteFunction
implements AsyncTaskExecuteFunction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentAsyncTaskExecuteFunction.class);
    private static final Duration DEFAULT_STATE_CHECK_INTERVAL = Duration.ofSeconds(10L);
    private final TaskExecutionContext taskExecutionContext;
    private final DependentParameters dependentParameters;
    private final ProjectDao projectDao;
    private final ProcessDefinitionDao processDefinitionDao;
    private final TaskDefinitionDao taskDefinitionDao;
    private final TaskInstanceDao taskInstanceDao;
    private final ProcessInstance processInstance;
    private final Date dependentDate;
    private final List<DependentExecute> dependentTaskList;
    private final Map<String, DependResult> dependResultMap;

    public DependentAsyncTaskExecuteFunction(TaskExecutionContext taskExecutionContext, DependentParameters dependentParameters, ProjectDao projectDao, ProcessDefinitionDao processDefinitionDao, TaskDefinitionDao taskDefinitionDao, TaskInstanceDao taskInstanceDao, ProcessInstanceDao processInstanceDao) {
        this.taskExecutionContext = taskExecutionContext;
        this.dependentParameters = dependentParameters;
        this.projectDao = projectDao;
        this.processDefinitionDao = processDefinitionDao;
        this.taskDefinitionDao = taskDefinitionDao;
        this.taskInstanceDao = taskInstanceDao;
        this.processInstance = (ProcessInstance)processInstanceDao.queryById((Serializable)Integer.valueOf(taskExecutionContext.getProcessInstanceId()));
        this.dependentDate = this.calculateDependentDate();
        this.dependentTaskList = this.initializeDependentTaskList();
        log.info("Initialized dependent task list successfully");
        this.dependResultMap = new HashMap<String, DependResult>();
    }

    @Override
    @NonNull
    public AsyncTaskExecuteFunction.AsyncTaskExecutionStatus getAsyncTaskExecutionStatus() {
        if (this.isAllDependentTaskFinished()) {
            log.info("All dependent task finished, will calculate the dependent result");
            DependResult dependResult = this.calculateDependResult();
            log.info("The Dependent result is: {}", (Object)dependResult);
            return dependResult == DependResult.SUCCESS ? AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.SUCCESS : AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.FAILED;
        }
        return AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.RUNNING;
    }

    private Date calculateDependentDate() {
        if (this.processInstance.getScheduleTime() != null) {
            return this.processInstance.getScheduleTime();
        }
        return new Date();
    }

    private List<DependentExecute> initializeDependentTaskList() {
        log.info("Begin to initialize dependent task list");
        HashSet<Long> projectCodes = new HashSet<Long>();
        HashSet<Long> processDefinitionCodes = new HashSet<Long>();
        HashSet<Long> taskDefinitionCodes = new HashSet<Long>();
        for (DependentTaskModel taskModel : this.dependentParameters.getDependTaskList()) {
            for (DependentItem dependentItem : taskModel.getDependItemList()) {
                projectCodes.add(dependentItem.getProjectCode());
                processDefinitionCodes.add(dependentItem.getDefinitionCode());
                taskDefinitionCodes.add(dependentItem.getDepTaskCode());
            }
        }
        Map projectCodeMap = this.projectDao.queryByCodes(new ArrayList(projectCodes)).stream().collect(Collectors.toMap(Project::getCode, Function.identity()));
        Map processDefinitionMap = this.processDefinitionDao.queryByCodes(processDefinitionCodes).stream().collect(Collectors.toMap(ProcessDefinition::getCode, Function.identity()));
        Map taskDefinitionMap = this.taskDefinitionDao.queryByCodes(taskDefinitionCodes).stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        List<DependentExecute> dependentExecutes = this.dependentParameters.getDependTaskList().stream().map(dependentTaskModel -> {
            for (DependentItem dependentItem : dependentTaskModel.getDependItemList()) {
                Project project = (Project)projectCodeMap.get(dependentItem.getProjectCode());
                if (project == null) {
                    log.error("The dependent task's project is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's project is not exist, dependentItem: " + dependentItem);
                }
                ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionMap.get(dependentItem.getDefinitionCode());
                if (processDefinition == null) {
                    log.error("The dependent task's workflow is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's workflow is not exist, dependentItem: " + dependentItem);
                }
                if (dependentItem.getDepTaskCode() == 0L) {
                    log.info("Add dependent task:");
                    log.info("DependentRelation: {}", (Object)dependentTaskModel.getRelation());
                    log.info("ProjectName: {}", (Object)project.getName());
                    log.info("WorkflowName: {}", (Object)processDefinition.getName());
                    log.info("TaskName: {}", (Object)"ALL");
                    log.info("DependentKey: {}", (Object)dependentItem.getKey());
                    continue;
                }
                TaskDefinition taskDefinition = (TaskDefinition)taskDefinitionMap.get(dependentItem.getDepTaskCode());
                if (taskDefinition == null) {
                    log.error("The dependent task's taskDefinition is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's taskDefinition is not exist, dependentItem: " + dependentItem);
                }
                log.info("Add dependent task:");
                log.info("DependentRelation: {}", (Object)dependentTaskModel.getRelation());
                log.info("ProjectName: {}", (Object)project.getName());
                log.info("WorkflowName: {}", (Object)processDefinition.getName());
                log.info("TaskName: {}", (Object)taskDefinition.getName());
                log.info("DependentKey: {}", (Object)dependentItem.getKey());
            }
            return new DependentExecute(dependentTaskModel.getDependItemList(), dependentTaskModel.getRelation(), this.processInstance, taskInstance);
        }).collect(Collectors.toList());
        log.info("Initialized dependent task list");
        return dependentExecutes;
    }

    private DependResult calculateDependResult() {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            DependResult dependResult = dependentExecute.getModelDependResult(this.dependentDate, this.processInstance.getTestFlag());
            dependResultList.add(dependResult);
        }
        return DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), dependResultList);
    }

    private boolean isAllDependentTaskFinished() {
        boolean isAllDependentTaskFinished = true;
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            if (!dependentExecute.finish(this.dependentDate, this.processInstance.getTestFlag(), this.dependentParameters.getFailurePolicy(), this.dependentParameters.getFailureWaitingTime())) {
                isAllDependentTaskFinished = false;
            }
            dependentExecute.getDependResultMap().forEach((dependentKey, dependResult) -> {
                if (!this.dependResultMap.containsKey(dependentKey)) {
                    this.dependResultMap.put((String)dependentKey, (DependResult)dependResult);
                    log.info("Dependent item check finished, {} dependentKey: {}, result: {}, dependentDate: {}", new Object[]{":||", dependentKey, dependResult, this.dependentDate});
                }
            });
        }
        return isAllDependentTaskFinished;
    }

    @Override
    @NonNull
    public Duration getAsyncTaskStateCheckInterval() {
        return this.dependentParameters.getCheckInterval() == null ? DEFAULT_STATE_CHECK_INTERVAL : Duration.ofSeconds(this.dependentParameters.getCheckInterval().intValue());
    }
}

