/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.subworkflow;

import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecuteFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubWorkflowAsyncTaskExecuteFunction
implements AsyncTaskExecuteFunction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubWorkflowAsyncTaskExecuteFunction.class);
    private static final Duration SUB_WORKFLOW_TASK_EXECUTE_STATE_CHECK_INTERVAL = Duration.ofSeconds(10L);
    private final TaskExecutionContext taskExecutionContext;
    private final ProcessInstanceDao processInstanceDao;
    private ProcessInstance subWorkflowInstance;

    public SubWorkflowAsyncTaskExecuteFunction(TaskExecutionContext taskExecutionContext, ProcessInstanceDao processInstanceDao) {
        this.taskExecutionContext = taskExecutionContext;
        this.processInstanceDao = processInstanceDao;
    }

    @Override
    @NonNull
    public AsyncTaskExecuteFunction.AsyncTaskExecutionStatus getAsyncTaskExecutionStatus() {
        if (this.subWorkflowInstance == null) {
            this.subWorkflowInstance = this.processInstanceDao.querySubProcessInstanceByParentId(Integer.valueOf(this.taskExecutionContext.getProcessInstanceId()), Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        }
        if (this.subWorkflowInstance == null) {
            log.info("The sub workflow instance doesn't created");
            return AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.RUNNING;
        }
        this.subWorkflowInstance = (ProcessInstance)this.processInstanceDao.queryById((Serializable)this.subWorkflowInstance.getId());
        if (this.subWorkflowInstance != null && this.subWorkflowInstance.getState().isFinished()) {
            return this.subWorkflowInstance.getState().isSuccess() ? AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.SUCCESS : AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.FAILED;
        }
        return AsyncTaskExecuteFunction.AsyncTaskExecutionStatus.RUNNING;
    }

    @Override
    @NonNull
    public Duration getAsyncTaskStateCheckInterval() {
        return SUB_WORKFLOW_TASK_EXECUTE_STATE_CHECK_INTERVAL;
    }
}

