/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.switchtask;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.SwitchResultVo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskInitializeException;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.task.BaseSyncLogicTask;
import org.apache.dolphinscheduler.server.master.utils.SwitchTaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchLogicTask
extends BaseSyncLogicTask<SwitchParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchLogicTask.class);
    public static final String TASK_TYPE = "SWITCH";
    private static final String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";
    private final ProcessInstance processInstance;
    private final TaskInstance taskInstance;

    public SwitchLogicTask(TaskExecutionContext taskExecutionContext, ProcessInstanceExecCacheManager processInstanceExecCacheManager) throws LogicTaskInitializeException {
        super(taskExecutionContext, processInstanceExecCacheManager.getByProcessInstanceId(taskExecutionContext.getProcessInstanceId()).getTaskInstance(taskExecutionContext.getTaskInstanceId()).orElseThrow(() -> new LogicTaskInitializeException("Cannot find the task instance in workflow execute runnable")).getSwitchDependency());
        WorkflowExecuteRunnable workflowExecuteRunnable = processInstanceExecCacheManager.getByProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        this.processInstance = workflowExecuteRunnable.getWorkflowExecuteContext().getWorkflowInstance();
        this.taskInstance = workflowExecuteRunnable.getTaskInstance(taskExecutionContext.getTaskInstanceId()).orElseThrow(() -> new LogicTaskInitializeException("Cannot find the task instance in workflow execute runnable"));
    }

    @Override
    public void handle() throws MasterTaskExecuteException {
        DependResult conditionResult = this.calculateConditionResult();
        TaskExecutionStatus status = conditionResult == DependResult.SUCCESS ? TaskExecutionStatus.SUCCESS : TaskExecutionStatus.FAILURE;
        log.info("Switch task execute finished, condition result is: {}, task status is: {}", (Object)conditionResult, (Object)status.name());
        this.taskExecutionContext.setCurrentExecutionStatus(status);
    }

    private DependResult calculateConditionResult() {
        DependResult conditionResult = DependResult.SUCCESS;
        List switchResultVos = ((SwitchParameters)this.taskParameters).getDependTaskList();
        SwitchResultVo switchResultVo = new SwitchResultVo();
        switchResultVo.setNextNode((Object)((SwitchParameters)this.taskParameters).getNextNode());
        switchResultVos.add(switchResultVo);
        int finalConditionLocation = switchResultVos.size() - 1;
        int i = 0;
        for (SwitchResultVo info : switchResultVos) {
            Boolean result;
            log.info("Begin to execute {} condition: {} ", (Object)(i + 1), (Object)info.getCondition());
            if (StringUtils.isEmpty((CharSequence)info.getCondition())) {
                finalConditionLocation = i;
                break;
            }
            String content = this.setTaskParams(info.getCondition().replaceAll("'", "\""), rgex);
            log.info("Format condition sentence::{} successfully", (Object)content);
            try {
                result = SwitchTaskUtils.evaluate(content);
                log.info("Execute condition sentence: {} successfully: {}", (Object)content, (Object)result);
            }
            catch (Exception e) {
                log.info("Execute condition sentence: {} failed", (Object)content, (Object)e);
                conditionResult = DependResult.FAILED;
                break;
            }
            if (result.booleanValue()) {
                finalConditionLocation = i;
                break;
            }
            ++i;
        }
        ((SwitchParameters)this.taskParameters).setDependTaskList(switchResultVos);
        ((SwitchParameters)this.taskParameters).setResultConditionLocation(finalConditionLocation);
        this.taskInstance.setSwitchDependency((SwitchParameters)this.taskParameters);
        if (!this.isValidSwitchResult((SwitchResultVo)switchResultVos.get(finalConditionLocation))) {
            conditionResult = DependResult.FAILED;
            log.error("The switch task depend result is invalid, result:{}, switch branch:{}", (Object)conditionResult, (Object)finalConditionLocation);
        }
        log.info("The switch task depend result:{}, switch branch:{}", (Object)conditionResult, (Object)finalConditionLocation);
        return conditionResult;
    }

    public String setTaskParams(String content, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        Map<String, Property> globalParams = JSONUtils.toList((String)this.processInstance.getGlobalParams(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        Map<String, Property> varParams = JSONUtils.toList((String)this.taskInstance.getVarPool(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        if (varParams.size() > 0) {
            varParams.putAll(globalParams);
            globalParams = varParams;
        }
        while (m.find()) {
            String paramName = m.group(1);
            Property property = globalParams.get(paramName);
            if (property == null) {
                return "";
            }
            String value = ParameterUtils.isNumber((Property)property) || ParameterUtils.isBoolean((Property)property) ? "" + ParameterUtils.getParameterValue((Property)property) : "\"" + ParameterUtils.getParameterValue((Property)property) + "\"";
            log.info("paramName:{}\uff0cparamValue:{}", (Object)paramName, (Object)value);
            content = content.replace("${" + paramName + "}", value);
        }
        return content;
    }

    private boolean isValidSwitchResult(SwitchResultVo switchResult) {
        if (CollectionUtils.isEmpty((Collection)switchResult.getNextNode())) {
            return false;
        }
        for (Long nextNode : switchResult.getNextNode()) {
            if (nextNode != null) continue;
            return false;
        }
        return true;
    }
}

