/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.builder.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.server.master.utils.TaskUtils;
import org.apache.dolphinscheduler.service.log.LogClient;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkerFailoverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerFailoverService.class);
    private final RegistryClient registryClient;
    private final MasterConfig masterConfig;
    private final ProcessService processService;
    private final WorkflowExecuteThreadPool workflowExecuteThreadPool;
    private final ProcessInstanceExecCacheManager cacheManager;
    private final LogClient logClient;
    private final String localAddress;
    private final TaskInstanceDao taskInstanceDao;

    public WorkerFailoverService(@NonNull RegistryClient registryClient, @NonNull MasterConfig masterConfig, @NonNull ProcessService processService, @NonNull WorkflowExecuteThreadPool workflowExecuteThreadPool, @NonNull ProcessInstanceExecCacheManager cacheManager, @NonNull LogClient logClient, @NonNull TaskInstanceDao taskInstanceDao) {
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (processService == null) {
            throw new NullPointerException("processService is marked non-null but is null");
        }
        if (workflowExecuteThreadPool == null) {
            throw new NullPointerException("workflowExecuteThreadPool is marked non-null but is null");
        }
        if (cacheManager == null) {
            throw new NullPointerException("cacheManager is marked non-null but is null");
        }
        if (logClient == null) {
            throw new NullPointerException("logClient is marked non-null but is null");
        }
        if (taskInstanceDao == null) {
            throw new NullPointerException("taskInstanceDao is marked non-null but is null");
        }
        this.registryClient = registryClient;
        this.masterConfig = masterConfig;
        this.processService = processService;
        this.workflowExecuteThreadPool = workflowExecuteThreadPool;
        this.cacheManager = cacheManager;
        this.logClient = logClient;
        this.localAddress = masterConfig.getMasterAddress();
        this.taskInstanceDao = taskInstanceDao;
    }

    public void failoverWorker(@NonNull String workerHost) {
        if (workerHost == null) {
            throw new NullPointerException("workerHost is marked non-null but is null");
        }
        log.info("Worker[{}] failover starting", (Object)workerHost);
        StopWatch failoverTimeCost = StopWatch.createStarted();
        Optional<Date> needFailoverWorkerStartTime = this.getServerStartupTime(this.registryClient.getServerList(RegistryNodeType.WORKER), workerHost);
        List<TaskInstance> needFailoverTaskInstanceList = this.getNeedFailoverTaskInstance(workerHost);
        if (CollectionUtils.isEmpty(needFailoverTaskInstanceList)) {
            log.info("Worker[{}] failover finished there are no taskInstance need to failover", (Object)workerHost);
            return;
        }
        log.info("Worker[{}] failover there are {} taskInstance may need to failover, will do a deep check, taskInstanceIds: {}", new Object[]{workerHost, needFailoverTaskInstanceList.size(), needFailoverTaskInstanceList.stream().map(TaskInstance::getId).collect(Collectors.toList())});
        HashMap<Integer, ProcessInstance> processInstanceCacheMap = new HashMap<Integer, ProcessInstance>();
        for (TaskInstance taskInstance : needFailoverTaskInstanceList) {
            ProcessInstance processInstance;
            Throwable throwable;
            LogUtils.MDCAutoClosableContext mdcAutoClosableContext;
            block18: {
                block19: {
                    mdcAutoClosableContext = LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskInstance.getProcessInstanceId(), (Integer)taskInstance.getId());
                    throwable = null;
                    processInstance = processInstanceCacheMap.computeIfAbsent(taskInstance.getProcessInstanceId(), k -> {
                        WorkflowExecuteRunnable workflowExecuteRunnable = this.cacheManager.getByProcessInstanceId(taskInstance.getProcessInstanceId());
                        if (workflowExecuteRunnable == null) {
                            return null;
                        }
                        return workflowExecuteRunnable.getWorkflowExecuteContext().getWorkflowInstance();
                    });
                    if (this.checkTaskInstanceNeedFailover(needFailoverWorkerStartTime, processInstance, taskInstance)) break block18;
                    log.info("Worker[{}] the current taskInstance doesn't need to failover", (Object)workerHost);
                    if (mdcAutoClosableContext == null) continue;
                    if (throwable == null) break block19;
                    try {
                        mdcAutoClosableContext.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                mdcAutoClosableContext.close();
                continue;
            }
            try {
                try {
                    log.info("Worker[{}] failover: begin to failover taskInstance, will set the status to NEED_FAULT_TOLERANCE", (Object)workerHost);
                    this.failoverTaskInstance(processInstance, taskInstance);
                    log.info("Worker[{}] failover: Finish failover taskInstance", (Object)workerHost);
                }
                catch (Exception ex) {
                    log.info("Worker[{}] failover taskInstance occur exception", (Object)workerHost, (Object)ex);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (mdcAutoClosableContext == null) continue;
                if (throwable != null) {
                    try {
                        mdcAutoClosableContext.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                mdcAutoClosableContext.close();
            }
        }
        failoverTimeCost.stop();
        log.info("Worker[{}] failover finished, useTime:{}ms", (Object)workerHost, (Object)failoverTimeCost.getTime(TimeUnit.MILLISECONDS));
    }

    private void failoverTaskInstance(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        TaskMetrics.incTaskInstanceByState("failover");
        taskInstance.setProcessInstance(processInstance);
        if (!TaskUtils.isMasterTask(taskInstance.getTaskType())) {
            log.info("The failover taskInstance is not master task");
            TaskExecutionContext taskExecutionContext = TaskExecutionContextBuilder.get().buildWorkflowInstanceHost(this.masterConfig.getMasterAddress()).buildTaskInstanceRelatedInfo(taskInstance).buildProcessInstanceRelatedInfo(processInstance).buildProcessDefinitionRelatedInfo(processInstance.getProcessDefinition()).create();
            if (this.masterConfig.isKillApplicationWhenTaskFailover()) {
                log.info("TaskInstance failover begin kill the task related yarn or k8s job");
                ProcessUtils.killApplication((LogClient)this.logClient, (TaskExecutionContext)taskExecutionContext);
            }
        } else {
            log.info("The failover taskInstance is a master task, no need to failover in worker failover");
        }
        taskInstance.setState(TaskExecutionStatus.NEED_FAULT_TOLERANCE);
        taskInstance.setFlag(Flag.NO);
        this.taskInstanceDao.upsertTaskInstance(taskInstance);
        TaskStateEvent stateEvent = TaskStateEvent.builder().processInstanceId(processInstance.getId()).taskInstanceId(taskInstance.getId()).status(TaskExecutionStatus.NEED_FAULT_TOLERANCE).type(StateEventType.TASK_STATE_CHANGE).build();
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    private boolean checkTaskInstanceNeedFailover(Optional<Date> needFailoverWorkerStartTime, @Nullable ProcessInstance processInstance, TaskInstance taskInstance) {
        if (processInstance == null) {
            log.error("Failover task instance error, cannot find the related processInstance form memory, this case shouldn't happened");
            return false;
        }
        if (taskInstance == null) {
            log.error("Master failover task instance error, taskInstance is null, this case shouldn't happened");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)processInstance.getHost(), (CharSequence)this.localAddress)) {
            log.error("Master failover task instance error, the taskInstance's processInstance's host: {} is not the current master: {}", (Object)processInstance.getHost(), (Object)this.localAddress);
            return false;
        }
        if (taskInstance.getState() != null && taskInstance.getState().isFinished()) {
            log.info("The task is already finished, doesn't need to failover");
            return false;
        }
        if (!needFailoverWorkerStartTime.isPresent()) {
            return true;
        }
        if (taskInstance.getSubmitTime() != null && taskInstance.getSubmitTime().after(needFailoverWorkerStartTime.get())) {
            log.info("The taskInstance's submitTime: {} is after the need failover worker's start time: {}, the taskInstance is newly submit, it doesn't need to failover", (Object)taskInstance.getSubmitTime(), (Object)needFailoverWorkerStartTime.get());
            return false;
        }
        return true;
    }

    private List<TaskInstance> getNeedFailoverTaskInstance(@NonNull String failoverWorkerHost) {
        if (failoverWorkerHost == null) {
            throw new NullPointerException("failoverWorkerHost is marked non-null but is null");
        }
        return this.cacheManager.getAll().stream().flatMap(workflowExecuteRunnable -> workflowExecuteRunnable.getAllTaskInstances().stream()).filter(taskInstance -> failoverWorkerHost.equals(taskInstance.getHost()) && taskInstance.getState().shouldFailover()).collect(Collectors.toList());
    }

    private Optional<Date> getServerStartupTime(List<Server> servers, String host) {
        if (CollectionUtils.isEmpty(servers)) {
            return Optional.empty();
        }
        Date serverStartupTime = null;
        for (Server server : servers) {
            if (!host.equals(server.getHost() + ":" + server.getPort())) continue;
            serverStartupTime = server.getCreateTime();
            break;
        }
        return Optional.ofNullable(serverStartupTime);
    }
}

