/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentExecute {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentExecute.class);
    private final ProcessInstanceDao processInstanceDao = (ProcessInstanceDao)SpringApplicationContext.getBean(ProcessInstanceDao.class);
    private final TaskInstanceDao taskInstanceDao = (TaskInstanceDao)SpringApplicationContext.getBean(TaskInstanceDao.class);
    private List<DependentItem> dependItemList;
    private DependentRelation relation;
    private ProcessInstance processInstance;
    private TaskInstance taskInstance;
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();

    public DependentExecute(List<DependentItem> itemList, DependentRelation relation, ProcessInstance processInstance, TaskInstance taskInstance) {
        this.dependItemList = itemList;
        this.relation = relation;
        this.processInstance = processInstance;
        this.taskInstance = taskInstance;
    }

    private DependResult getDependentResultForItem(DependentItem dependentItem, Date currentTime, int testFlag) {
        List dateIntervals = DependentUtils.getDateIntervalList((Date)currentTime, (String)dependentItem.getDateValue());
        return this.calculateResultForTasks(dependentItem, dateIntervals, testFlag);
    }

    private DependResult calculateResultForTasks(DependentItem dependentItem, List<DateInterval> dateIntervals, int testFlag) {
        DependResult result = DependResult.FAILED;
        for (DateInterval dateInterval : dateIntervals) {
            ProcessInstance processInstance = this.findLastProcessInterval(dependentItem.getDefinitionCode(), dateInterval, testFlag);
            if (processInstance == null) {
                return DependResult.WAITING;
            }
            result = dependentItem.getDepTaskCode() == 0L ? this.dependResultByProcessInstance(processInstance) : this.getDependTaskResult(dependentItem.getDepTaskCode(), processInstance, testFlag);
            if (result == DependResult.SUCCESS) continue;
            break;
        }
        return result;
    }

    private DependResult dependResultByProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.getState().isFinished()) {
            return DependResult.WAITING;
        }
        if (processInstance.getState().isSuccess()) {
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DependResult getDependTaskResult(long taskCode, ProcessInstance processInstance, int testFlag) {
        TaskInstance taskInstance = null;
        List taskInstanceList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(processInstance.getId(), testFlag);
        for (TaskInstance task : taskInstanceList) {
            if (task.getTaskCode() != taskCode) continue;
            taskInstance = task;
            break;
        }
        if (taskInstance != null) return this.getDependResultByState(taskInstance.getState());
        if (!processInstance.getState().isFinished()) return DependResult.WAITING;
        return DependResult.FAILED;
    }

    private ProcessInstance findLastProcessInterval(Long definitionCode, DateInterval dateInterval, int testFlag) {
        ProcessInstance lastSchedulerProcess = this.processInstanceDao.queryLastSchedulerProcessInterval(definitionCode, dateInterval, testFlag);
        ProcessInstance lastManualProcess = this.processInstanceDao.queryLastManualProcessInterval(definitionCode, dateInterval, testFlag);
        if (lastManualProcess == null) {
            return lastSchedulerProcess;
        }
        if (lastSchedulerProcess == null) {
            return lastManualProcess;
        }
        return lastManualProcess.getId() > lastSchedulerProcess.getId() ? lastManualProcess : lastSchedulerProcess;
    }

    private DependResult getDependResultByState(TaskExecutionStatus state) {
        if (!state.isFinished()) {
            return DependResult.WAITING;
        }
        if (state.isSuccess()) {
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    public boolean finish(Date currentTime, int testFlag, DependentParameters.DependentFailurePolicyEnum failurePolicy, Integer failureWaitingTime) {
        DependResult modelDependResult = this.getModelDependResult(currentTime, testFlag);
        if (modelDependResult == DependResult.WAITING) {
            return false;
        }
        if (modelDependResult == DependResult.FAILED && DependentParameters.DependentFailurePolicyEnum.DEPENDENT_FAILURE_WAITING == failurePolicy && failureWaitingTime != null) {
            return Duration.between(currentTime.toInstant(), Instant.now()).compareTo(Duration.ofMinutes(failureWaitingTime.intValue())) > 0;
        }
        return true;
    }

    public DependResult getModelDependResult(Date currentTime, int testFlag) {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentItem dependentItem : this.dependItemList) {
            if (this.isSelfDependent(dependentItem) && this.isFirstProcessInstance(dependentItem)) {
                this.dependResultMap.put(dependentItem.getKey(), DependResult.SUCCESS);
                dependResultList.add(DependResult.SUCCESS);
                log.info("This dependent item is self-dependent and run at first time, default success, processDefinitionCode:{}, depTaskCode:{}", (Object)dependentItem.getDefinitionCode(), (Object)dependentItem.getDepTaskCode());
                continue;
            }
            DependResult dependResult = this.getDependResultForItem(dependentItem, currentTime, testFlag);
            if (dependResult != DependResult.WAITING && dependResult != DependResult.FAILED) {
                this.dependResultMap.put(dependentItem.getKey(), dependResult);
            }
            dependResultList.add(dependResult);
        }
        return DependentUtils.getDependResultForRelation((DependentRelation)this.relation, dependResultList);
    }

    private DependResult getDependResultForItem(DependentItem item, Date currentTime, int testFlag) {
        String key = item.getKey();
        if (this.dependResultMap.containsKey(key)) {
            return this.dependResultMap.get(key);
        }
        return this.getDependentResultForItem(item, currentTime, testFlag);
    }

    public Map<String, DependResult> getDependResultMap() {
        return this.dependResultMap;
    }

    public boolean isSelfDependent(DependentItem dependentItem) {
        if (this.processInstance.getProcessDefinitionCode().equals(dependentItem.getDefinitionCode())) {
            if (dependentItem.getDepTaskCode() == 0L) {
                return true;
            }
            if (dependentItem.getDepTaskCode() == this.taskInstance.getTaskCode()) {
                return true;
            }
        }
        return false;
    }

    public boolean isFirstProcessInstance(DependentItem dependentItem) {
        ProcessInstance firstProcessInstance = this.processInstanceDao.queryFirstScheduleProcessInstance(Long.valueOf(dependentItem.getDefinitionCode()));
        if (firstProcessInstance == null && (firstProcessInstance = this.processInstanceDao.queryFirstStartProcessInstance(Long.valueOf(dependentItem.getDefinitionCode()))) == null) {
            log.warn("First process instance is null, processDefinitionCode:{}", (Object)dependentItem.getDefinitionCode());
            return false;
        }
        return firstProcessInstance.getId() == this.processInstance.getId();
    }
}

