/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.scheduler.api.SchedulerApi;
import org.apache.dolphinscheduler.server.master.metrics.MasterServerMetrics;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.server.master.registry.MasterSlotManager;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcServer;
import org.apache.dolphinscheduler.server.master.runner.EventExecuteService;
import org.apache.dolphinscheduler.server.master.runner.FailoverExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.MasterSchedulerBootstrap;
import org.apache.dolphinscheduler.server.master.runner.taskgroup.TaskGroupCoordinator;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
@EnableTransactionManagement
@EnableCaching
public class MasterServer
implements IStoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterServer.class);
    @Autowired
    private SpringApplicationContext springApplicationContext;
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private MasterSchedulerBootstrap masterSchedulerBootstrap;
    @Autowired
    private SchedulerApi schedulerApi;
    @Autowired
    private EventExecuteService eventExecuteService;
    @Autowired
    private FailoverExecuteThread failoverExecuteThread;
    @Autowired
    private MasterRpcServer masterRPCServer;
    @Autowired
    private MetricsProvider metricsProvider;
    @Autowired
    private MasterSlotManager masterSlotManager;
    @Autowired
    private TaskGroupCoordinator taskGroupCoordinator;

    public static void main(String[] args) {
        MasterServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("Master-Server");
        SpringApplication.run(MasterServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() throws SchedulerException {
        this.masterRPCServer.start();
        this.taskPluginManager.loadPlugin();
        this.masterSlotManager.start();
        this.masterRegistryClient.start();
        this.masterRegistryClient.setRegistryStoppable(this);
        this.masterSchedulerBootstrap.start();
        this.eventExecuteService.start();
        this.failoverExecuteThread.start();
        this.schedulerApi.start();
        this.taskGroupCoordinator.start();
        MasterServerMetrics.registerMasterCpuUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getTotalCpuUsedPercentage();
        });
        MasterServerMetrics.registerMasterMemoryAvailableGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return (systemMetrics.getSystemMemoryMax() - systemMetrics.getSystemMemoryUsed()) / 1024.0 / 1024.0 / 1024.0;
        });
        MasterServerMetrics.registerMasterMemoryUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getJvmMemoryUsedPercentage();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!ServerLifeCycleManager.isStopped()) {
                this.close("MasterServer shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        if (!ServerLifeCycleManager.toStopped()) {
            log.warn("MasterServer is already stopped, current cause: {}", (Object)cause);
            return;
        }
        ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
        try (SchedulerApi closedSchedulerApi = this.schedulerApi;
             MasterSchedulerBootstrap closedSchedulerBootstrap = this.masterSchedulerBootstrap;
             MasterRpcServer closedRpcServer = this.masterRPCServer;
             MasterRegistryClient closedMasterRegistryClient = this.masterRegistryClient;
             SpringApplicationContext closedSpringContext = this.springApplicationContext;){
            log.info("Master server is stopping, current cause : {}", (Object)cause);
        }
        catch (Exception e) {
            log.error("MasterServer stop failed, current cause: {}", (Object)cause, (Object)e);
            return;
        }
        log.info("MasterServer stopped, current cause: {}", (Object)cause);
    }

    public void stop(String cause) {
        this.close(cause);
    }
}

