/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.ConnectStrategyProperties;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.config.MasterServerLoadProtection;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="master")
public class MasterConfig
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterConfig.class);
    private int listenPort = 5678;
    private int fetchCommandNum = 10;
    private int preExecThreads = 10;
    private int execThreads = 10;
    private int masterSyncTaskExecutorThreadPoolSize = Runtime.getRuntime().availableProcessors();
    private int masterAsyncTaskExecutorThreadPoolSize = Runtime.getRuntime().availableProcessors();
    private int dispatchTaskNumber = 3;
    private HostSelector hostSelector = HostSelector.LOWER_WEIGHT;
    private Duration maxHeartbeatInterval = Duration.ofSeconds(10L);
    private int taskCommitRetryTimes = 5;
    private Duration taskCommitInterval = Duration.ofSeconds(1L);
    private Duration stateWheelInterval = Duration.ofMillis(5L);
    private MasterServerLoadProtection serverLoadProtection = new MasterServerLoadProtection();
    private Duration failoverInterval = Duration.ofMinutes(10L);
    private boolean killApplicationWhenTaskFailover = true;
    private ConnectStrategyProperties registryDisconnectStrategy = new ConnectStrategyProperties();
    private Duration workerGroupRefreshInterval = Duration.ofSeconds(10L);
    private String masterAddress;
    private String masterRegistryPath;

    public boolean supports(Class<?> clazz) {
        return MasterConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        MasterConfig masterConfig = (MasterConfig)target;
        if (masterConfig.getListenPort() <= 0) {
            errors.rejectValue("listen-port", null, "is invalidated");
        }
        if (masterConfig.getFetchCommandNum() <= 0) {
            errors.rejectValue("fetch-command-num", null, "should be a positive value");
        }
        if (masterConfig.getPreExecThreads() <= 0) {
            errors.rejectValue("per-exec-threads", null, "should be a positive value");
        }
        if (masterConfig.getExecThreads() <= 0) {
            errors.rejectValue("exec-threads", null, "should be a positive value");
        }
        if (masterConfig.getDispatchTaskNumber() <= 0) {
            errors.rejectValue("dispatch-task-number", null, "should be a positive value");
        }
        if (masterConfig.getMaxHeartbeatInterval().toMillis() < 0L) {
            errors.rejectValue("max-heartbeat-interval", null, "should be a valid duration");
        }
        if (masterConfig.getTaskCommitRetryTimes() <= 0) {
            errors.rejectValue("task-commit-retry-times", null, "should be a positive value");
        }
        if (masterConfig.getTaskCommitInterval().toMillis() <= 0L) {
            errors.rejectValue("task-commit-interval", null, "should be a valid duration");
        }
        if (masterConfig.getStateWheelInterval().toMillis() <= 0L) {
            errors.rejectValue("state-wheel-interval", null, "should be a valid duration");
        }
        if (masterConfig.getFailoverInterval().toMillis() <= 0L) {
            errors.rejectValue("failover-interval", null, "should be a valid duration");
        }
        if (masterConfig.getWorkerGroupRefreshInterval().getSeconds() < 10L) {
            errors.rejectValue("worker-group-refresh-interval", null, "should >= 10s");
        }
        if (StringUtils.isEmpty((CharSequence)masterConfig.getMasterAddress())) {
            masterConfig.setMasterAddress(NetUtils.getAddr((int)masterConfig.getListenPort()));
        }
        masterConfig.setMasterRegistryPath(RegistryNodeType.MASTER.getRegistryPath() + "/" + masterConfig.getMasterAddress());
        this.printConfig();
    }

    private void printConfig() {
        String config = "\n****************************Master Configuration**************************************\n  listen-port -> " + this.listenPort + "\n  fetch-command-num -> " + this.fetchCommandNum + "\n  pre-exec-threads -> " + this.preExecThreads + "\n  exec-threads -> " + this.execThreads + "\n  dispatch-task-number -> " + this.dispatchTaskNumber + "\n  host-selector -> " + (Object)((Object)this.hostSelector) + "\n  max-heartbeat-interval -> " + this.maxHeartbeatInterval + "\n  task-commit-retry-times -> " + this.taskCommitRetryTimes + "\n  task-commit-interval -> " + this.taskCommitInterval + "\n  state-wheel-interval -> " + this.stateWheelInterval + "\n  server-load-protection -> " + this.serverLoadProtection + "\n  failover-interval -> " + this.failoverInterval + "\n  kill-application-when-task-failover -> " + this.killApplicationWhenTaskFailover + "\n  registry-disconnect-strategy -> " + this.registryDisconnectStrategy + "\n  master-address -> " + this.masterAddress + "\n  master-registry-path: " + this.masterRegistryPath + "\n  worker-group-refresh-interval: " + this.workerGroupRefreshInterval + "\n****************************Master Configuration**************************************";
        log.info(config);
    }

    @Generated
    public MasterConfig() {
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public int getFetchCommandNum() {
        return this.fetchCommandNum;
    }

    @Generated
    public int getPreExecThreads() {
        return this.preExecThreads;
    }

    @Generated
    public int getExecThreads() {
        return this.execThreads;
    }

    @Generated
    public int getMasterSyncTaskExecutorThreadPoolSize() {
        return this.masterSyncTaskExecutorThreadPoolSize;
    }

    @Generated
    public int getMasterAsyncTaskExecutorThreadPoolSize() {
        return this.masterAsyncTaskExecutorThreadPoolSize;
    }

    @Generated
    public int getDispatchTaskNumber() {
        return this.dispatchTaskNumber;
    }

    @Generated
    public HostSelector getHostSelector() {
        return this.hostSelector;
    }

    @Generated
    public Duration getMaxHeartbeatInterval() {
        return this.maxHeartbeatInterval;
    }

    @Generated
    public int getTaskCommitRetryTimes() {
        return this.taskCommitRetryTimes;
    }

    @Generated
    public Duration getTaskCommitInterval() {
        return this.taskCommitInterval;
    }

    @Generated
    public Duration getStateWheelInterval() {
        return this.stateWheelInterval;
    }

    @Generated
    public MasterServerLoadProtection getServerLoadProtection() {
        return this.serverLoadProtection;
    }

    @Generated
    public Duration getFailoverInterval() {
        return this.failoverInterval;
    }

    @Generated
    public boolean isKillApplicationWhenTaskFailover() {
        return this.killApplicationWhenTaskFailover;
    }

    @Generated
    public ConnectStrategyProperties getRegistryDisconnectStrategy() {
        return this.registryDisconnectStrategy;
    }

    @Generated
    public Duration getWorkerGroupRefreshInterval() {
        return this.workerGroupRefreshInterval;
    }

    @Generated
    public String getMasterAddress() {
        return this.masterAddress;
    }

    @Generated
    public String getMasterRegistryPath() {
        return this.masterRegistryPath;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setFetchCommandNum(int fetchCommandNum) {
        this.fetchCommandNum = fetchCommandNum;
    }

    @Generated
    public void setPreExecThreads(int preExecThreads) {
        this.preExecThreads = preExecThreads;
    }

    @Generated
    public void setExecThreads(int execThreads) {
        this.execThreads = execThreads;
    }

    @Generated
    public void setMasterSyncTaskExecutorThreadPoolSize(int masterSyncTaskExecutorThreadPoolSize) {
        this.masterSyncTaskExecutorThreadPoolSize = masterSyncTaskExecutorThreadPoolSize;
    }

    @Generated
    public void setMasterAsyncTaskExecutorThreadPoolSize(int masterAsyncTaskExecutorThreadPoolSize) {
        this.masterAsyncTaskExecutorThreadPoolSize = masterAsyncTaskExecutorThreadPoolSize;
    }

    @Generated
    public void setDispatchTaskNumber(int dispatchTaskNumber) {
        this.dispatchTaskNumber = dispatchTaskNumber;
    }

    @Generated
    public void setHostSelector(HostSelector hostSelector) {
        this.hostSelector = hostSelector;
    }

    @Generated
    public void setMaxHeartbeatInterval(Duration maxHeartbeatInterval) {
        this.maxHeartbeatInterval = maxHeartbeatInterval;
    }

    @Generated
    public void setTaskCommitRetryTimes(int taskCommitRetryTimes) {
        this.taskCommitRetryTimes = taskCommitRetryTimes;
    }

    @Generated
    public void setTaskCommitInterval(Duration taskCommitInterval) {
        this.taskCommitInterval = taskCommitInterval;
    }

    @Generated
    public void setStateWheelInterval(Duration stateWheelInterval) {
        this.stateWheelInterval = stateWheelInterval;
    }

    @Generated
    public void setServerLoadProtection(MasterServerLoadProtection serverLoadProtection) {
        this.serverLoadProtection = serverLoadProtection;
    }

    @Generated
    public void setFailoverInterval(Duration failoverInterval) {
        this.failoverInterval = failoverInterval;
    }

    @Generated
    public void setKillApplicationWhenTaskFailover(boolean killApplicationWhenTaskFailover) {
        this.killApplicationWhenTaskFailover = killApplicationWhenTaskFailover;
    }

    @Generated
    public void setRegistryDisconnectStrategy(ConnectStrategyProperties registryDisconnectStrategy) {
        this.registryDisconnectStrategy = registryDisconnectStrategy;
    }

    @Generated
    public void setWorkerGroupRefreshInterval(Duration workerGroupRefreshInterval) {
        this.workerGroupRefreshInterval = workerGroupRefreshInterval;
    }

    @Generated
    public void setMasterAddress(String masterAddress) {
        this.masterAddress = masterAddress;
    }

    @Generated
    public void setMasterRegistryPath(String masterRegistryPath) {
        this.masterRegistryPath = masterRegistryPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterConfig)) {
            return false;
        }
        MasterConfig other = (MasterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getFetchCommandNum() != other.getFetchCommandNum()) {
            return false;
        }
        if (this.getPreExecThreads() != other.getPreExecThreads()) {
            return false;
        }
        if (this.getExecThreads() != other.getExecThreads()) {
            return false;
        }
        if (this.getMasterSyncTaskExecutorThreadPoolSize() != other.getMasterSyncTaskExecutorThreadPoolSize()) {
            return false;
        }
        if (this.getMasterAsyncTaskExecutorThreadPoolSize() != other.getMasterAsyncTaskExecutorThreadPoolSize()) {
            return false;
        }
        if (this.getDispatchTaskNumber() != other.getDispatchTaskNumber()) {
            return false;
        }
        if (this.getTaskCommitRetryTimes() != other.getTaskCommitRetryTimes()) {
            return false;
        }
        if (this.isKillApplicationWhenTaskFailover() != other.isKillApplicationWhenTaskFailover()) {
            return false;
        }
        HostSelector this$hostSelector = this.getHostSelector();
        HostSelector other$hostSelector = other.getHostSelector();
        if (this$hostSelector == null ? other$hostSelector != null : !((Object)((Object)this$hostSelector)).equals((Object)other$hostSelector)) {
            return false;
        }
        Duration this$maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        Duration other$maxHeartbeatInterval = other.getMaxHeartbeatInterval();
        if (this$maxHeartbeatInterval == null ? other$maxHeartbeatInterval != null : !((Object)this$maxHeartbeatInterval).equals(other$maxHeartbeatInterval)) {
            return false;
        }
        Duration this$taskCommitInterval = this.getTaskCommitInterval();
        Duration other$taskCommitInterval = other.getTaskCommitInterval();
        if (this$taskCommitInterval == null ? other$taskCommitInterval != null : !((Object)this$taskCommitInterval).equals(other$taskCommitInterval)) {
            return false;
        }
        Duration this$stateWheelInterval = this.getStateWheelInterval();
        Duration other$stateWheelInterval = other.getStateWheelInterval();
        if (this$stateWheelInterval == null ? other$stateWheelInterval != null : !((Object)this$stateWheelInterval).equals(other$stateWheelInterval)) {
            return false;
        }
        MasterServerLoadProtection this$serverLoadProtection = this.getServerLoadProtection();
        MasterServerLoadProtection other$serverLoadProtection = other.getServerLoadProtection();
        if (this$serverLoadProtection == null ? other$serverLoadProtection != null : !((Object)this$serverLoadProtection).equals(other$serverLoadProtection)) {
            return false;
        }
        Duration this$failoverInterval = this.getFailoverInterval();
        Duration other$failoverInterval = other.getFailoverInterval();
        if (this$failoverInterval == null ? other$failoverInterval != null : !((Object)this$failoverInterval).equals(other$failoverInterval)) {
            return false;
        }
        ConnectStrategyProperties this$registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        ConnectStrategyProperties other$registryDisconnectStrategy = other.getRegistryDisconnectStrategy();
        if (this$registryDisconnectStrategy == null ? other$registryDisconnectStrategy != null : !this$registryDisconnectStrategy.equals(other$registryDisconnectStrategy)) {
            return false;
        }
        Duration this$workerGroupRefreshInterval = this.getWorkerGroupRefreshInterval();
        Duration other$workerGroupRefreshInterval = other.getWorkerGroupRefreshInterval();
        if (this$workerGroupRefreshInterval == null ? other$workerGroupRefreshInterval != null : !((Object)this$workerGroupRefreshInterval).equals(other$workerGroupRefreshInterval)) {
            return false;
        }
        String this$masterAddress = this.getMasterAddress();
        String other$masterAddress = other.getMasterAddress();
        if (this$masterAddress == null ? other$masterAddress != null : !this$masterAddress.equals(other$masterAddress)) {
            return false;
        }
        String this$masterRegistryPath = this.getMasterRegistryPath();
        String other$masterRegistryPath = other.getMasterRegistryPath();
        return !(this$masterRegistryPath == null ? other$masterRegistryPath != null : !this$masterRegistryPath.equals(other$masterRegistryPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MasterConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getFetchCommandNum();
        result = result * 59 + this.getPreExecThreads();
        result = result * 59 + this.getExecThreads();
        result = result * 59 + this.getMasterSyncTaskExecutorThreadPoolSize();
        result = result * 59 + this.getMasterAsyncTaskExecutorThreadPoolSize();
        result = result * 59 + this.getDispatchTaskNumber();
        result = result * 59 + this.getTaskCommitRetryTimes();
        result = result * 59 + (this.isKillApplicationWhenTaskFailover() ? 79 : 97);
        HostSelector $hostSelector = this.getHostSelector();
        result = result * 59 + ($hostSelector == null ? 43 : ((Object)((Object)$hostSelector)).hashCode());
        Duration $maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        result = result * 59 + ($maxHeartbeatInterval == null ? 43 : ((Object)$maxHeartbeatInterval).hashCode());
        Duration $taskCommitInterval = this.getTaskCommitInterval();
        result = result * 59 + ($taskCommitInterval == null ? 43 : ((Object)$taskCommitInterval).hashCode());
        Duration $stateWheelInterval = this.getStateWheelInterval();
        result = result * 59 + ($stateWheelInterval == null ? 43 : ((Object)$stateWheelInterval).hashCode());
        MasterServerLoadProtection $serverLoadProtection = this.getServerLoadProtection();
        result = result * 59 + ($serverLoadProtection == null ? 43 : ((Object)$serverLoadProtection).hashCode());
        Duration $failoverInterval = this.getFailoverInterval();
        result = result * 59 + ($failoverInterval == null ? 43 : ((Object)$failoverInterval).hashCode());
        ConnectStrategyProperties $registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        result = result * 59 + ($registryDisconnectStrategy == null ? 43 : $registryDisconnectStrategy.hashCode());
        Duration $workerGroupRefreshInterval = this.getWorkerGroupRefreshInterval();
        result = result * 59 + ($workerGroupRefreshInterval == null ? 43 : ((Object)$workerGroupRefreshInterval).hashCode());
        String $masterAddress = this.getMasterAddress();
        result = result * 59 + ($masterAddress == null ? 43 : $masterAddress.hashCode());
        String $masterRegistryPath = this.getMasterRegistryPath();
        result = result * 59 + ($masterRegistryPath == null ? 43 : $masterRegistryPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MasterConfig(listenPort=" + this.getListenPort() + ", fetchCommandNum=" + this.getFetchCommandNum() + ", preExecThreads=" + this.getPreExecThreads() + ", execThreads=" + this.getExecThreads() + ", masterSyncTaskExecutorThreadPoolSize=" + this.getMasterSyncTaskExecutorThreadPoolSize() + ", masterAsyncTaskExecutorThreadPoolSize=" + this.getMasterAsyncTaskExecutorThreadPoolSize() + ", dispatchTaskNumber=" + this.getDispatchTaskNumber() + ", hostSelector=" + (Object)((Object)this.getHostSelector()) + ", maxHeartbeatInterval=" + this.getMaxHeartbeatInterval() + ", taskCommitRetryTimes=" + this.getTaskCommitRetryTimes() + ", taskCommitInterval=" + this.getTaskCommitInterval() + ", stateWheelInterval=" + this.getStateWheelInterval() + ", serverLoadProtection=" + this.getServerLoadProtection() + ", failoverInterval=" + this.getFailoverInterval() + ", killApplicationWhenTaskFailover=" + this.isKillApplicationWhenTaskFailover() + ", registryDisconnectStrategy=" + this.getRegistryDisconnectStrategy() + ", workerGroupRefreshInterval=" + this.getWorkerGroupRefreshInterval() + ", masterAddress=" + this.getMasterAddress() + ", masterRegistryPath=" + this.getMasterRegistryPath() + ")";
    }
}

